/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonatype.nexus.blobstore.api.BlobId;

public class BlobRef {
    private final String node;
    private final String store;
    private final String blob;
    public static final Pattern BLOB_REF_PATTERN = Pattern.compile("([^@]+)@([^:]+):(.*)");

    public BlobRef(String node, String store, String blob) {
        this.node = (String)Preconditions.checkNotNull((Object)node);
        this.store = (String)Preconditions.checkNotNull((Object)store);
        this.blob = (String)Preconditions.checkNotNull((Object)blob);
    }

    public String getNode() {
        return this.node;
    }

    public String getStore() {
        return this.store;
    }

    public String getBlob() {
        return this.blob;
    }

    public BlobId getBlobId() {
        return new BlobId(this.getBlob());
    }

    public static BlobRef parse(String spec) {
        Matcher matcher = BLOB_REF_PATTERN.matcher(spec);
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Not a valid blob reference");
        return new BlobRef(matcher.group(2), matcher.group(1), matcher.group(3));
    }

    public String toString() {
        return String.format("%s@%s:%s", this.getStore(), this.getNode(), this.getBlob());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobRef blobRef = (BlobRef)o;
        if (!this.blob.equals(blobRef.blob)) {
            return false;
        }
        if (!this.node.equals(blobRef.node)) {
            return false;
        }
        return this.store.equals(blobRef.store);
    }

    public int hashCode() {
        int result = this.node.hashCode();
        result = 31 * result + this.store.hashCode();
        result = 31 * result + this.blob.hashCode();
        return result;
    }
}

