/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.api;

import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.BlobId;

public class BlobStoreException
extends RuntimeException {
    private final BlobId blobId;

    public BlobStoreException(String message, @Nullable BlobId blobId) {
        super(message);
        this.blobId = blobId;
    }

    public BlobStoreException(String message, Throwable cause, @Nullable BlobId blobId) {
        super(message, cause);
        this.blobId = blobId;
    }

    public BlobStoreException(Throwable cause, @Nullable BlobId blobId) {
        super(cause);
        this.blobId = blobId;
    }

    @Nullable
    public BlobId getBlobId() {
        return this.blobId;
    }

    @Override
    public String getMessage() {
        StringJoiner joiner = new StringJoiner(", ");
        if (this.blobId != null) {
            joiner.add("BlobId: " + this.blobId);
        }
        joiner.add(super.getMessage());
        if (this.getCause() != null && this.getCause().getMessage() != null) {
            joiner.add("Cause: " + this.getCause().getMessage());
        }
        return joiner.toString();
    }
}

