/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.internal.NpmRestoreBlobData;
import org.sonatype.nexus.blobstore.restore.internal.NpmRestoreBlobDataFactory;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.npm.NpmFacet;
import org.sonatype.nexus.repository.npm.repair.NpmRepairPackageRootComponent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;

@Named(value="npm")
@Singleton
public class NpmRestoreBlobStrategy
extends BaseRestoreBlobStrategy<NpmRestoreBlobData> {
    private final NpmRepairPackageRootComponent npmRepairPackageRootComponent;

    @Inject
    public NpmRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix, NpmRepairPackageRootComponent npmRepairPackageRootComponent) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.npmRepairPackageRootComponent = (NpmRepairPackageRootComponent)Preconditions.checkNotNull((Object)npmRepairPackageRootComponent);
    }

    protected NpmRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return NpmRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull NpmRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional npmFacet = repository.optionalFacet(NpmFacet.class);
        if (!npmFacet.isPresent()) {
            this.log.warn("Skipping as NPM Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull NpmRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    @TransactionalTouchBlob
    protected boolean assetExists(@Nonnull NpmRestoreBlobData data) {
        Asset asset;
        NpmFacet facet = (NpmFacet)data.getBlobData().getRepository().facet(NpmFacet.class);
        switch (data.getType()) {
            case REPOSITORY_ROOT: {
                asset = facet.findRepositoryRootAsset();
                break;
            }
            case TARBALL: {
                asset = facet.findTarballAsset(data.getPackageId(), data.getTarballName());
                break;
            }
            case PACKAGE_ROOT: {
                asset = facet.findPackageRootAsset(data.getPackageId());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected case encountered");
            }
        }
        return asset != null;
    }

    @TransactionalStoreMetadata
    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull NpmRestoreBlobData data) throws IOException {
        NpmFacet facet = (NpmFacet)data.getBlobData().getRepository().facet(NpmFacet.class);
        switch (data.getType()) {
            case REPOSITORY_ROOT: {
                facet.putRepositoryRoot(assetBlob, null);
                break;
            }
            case TARBALL: {
                facet.putTarball(data.getPackageId(), data.getTarballName(), assetBlob, null);
                break;
            }
            case PACKAGE_ROOT: {
                facet.putPackageRoot(data.getPackageId(), assetBlob, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected case encountered");
            }
        }
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.npmRepairPackageRootComponent.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of npm package metadata");
        }
    }
}

