/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Model;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenValidatingComponentUpload;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.Maven2MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.MavenPomGenerator;
import org.sonatype.nexus.repository.maven.internal.VersionPolicyValidator;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadFieldDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadRegexMap;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.upload.ValidatingComponentUpload;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="maven2")
@Singleton
public class MavenUploadHandler
extends UploadHandlerSupport {
    private static final String COMPONENT_COORDINATES_GROUP = "Component coordinates";
    private static final String GENERATE_POM_DISPLAY = "Generate a POM file with these coordinates";
    private static final String GENERATE_POM = "generate-pom";
    private static final String EXTENSION = "extension";
    private static final String CLASSIFIER = "classifier";
    private static final String VERSION = "version";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String GROUP_ID = "groupId";
    private static final String PACKAGING = "packaging";
    private static final String ARTIFACT_ID_DISPLAY = "Artifact ID";
    private static final String GROUP_ID_DISPLAY = "Group ID";
    private static final String MAVEN_POM_PROPERTY_PREFIX = "${";
    private final ContentPermissionChecker contentPermissionChecker;
    private final Maven2MavenPathParser parser;
    private final MavenPomGenerator mavenPomGenerator;
    private UploadDefinition definition;
    private final VariableResolverAdapter variableResolverAdapter;
    private final VersionPolicyValidator versionPolicyValidator;

    @Inject
    public MavenUploadHandler(Maven2MavenPathParser parser, @Named(value="maven2") VariableResolverAdapter variableResolverAdapter, ContentPermissionChecker contentPermissionChecker, VersionPolicyValidator versionPolicyValidator, MavenPomGenerator mavenPomGenerator, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.parser = parser;
        this.variableResolverAdapter = variableResolverAdapter;
        this.contentPermissionChecker = contentPermissionChecker;
        this.versionPolicyValidator = versionPolicyValidator;
        this.mavenPomGenerator = mavenPomGenerator;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)upload);
        return this.doUpload(repository, upload);
    }

    private UploadResponse doUpload(Repository repository, ComponentUpload componentUpload) throws IOException {
        MavenFacet facet = (MavenFacet)repository.facet(MavenFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        if (VersionPolicy.SNAPSHOT.equals((Object)facet.getVersionPolicy())) {
            throw new ValidationErrorsException("Upload to snapshot repositories not supported, use the maven client.");
        }
        AssetUpload pomAsset = this.findPomAsset(componentUpload);
        try (TempBlob pom = null;){
            ContentAndAssetPathResponseData responseData;
            if (pomAsset != null) {
                PartPayload payload = pomAsset.getPayload();
                pom = storageFacet.createTempBlob((Payload)payload, MavenPath.HashType.ALGORITHMS);
                pomAsset.setPayload((PartPayload)new TempBlobPartPayload(payload, pom));
            }
            String basePath = this.getBasePath(componentUpload, pom);
            this.doValidation(repository, basePath, componentUpload.getAssetUploads());
            UnitOfWork.begin((Supplier)storageFacet.txSupplier());
            try {
                responseData = this.createAssets(repository, basePath, componentUpload.getAssetUploads());
                if (Boolean.valueOf(componentUpload.getField(GENERATE_POM)).booleanValue()) {
                    String pomPath = this.generatePom(repository, basePath, (String)componentUpload.getFields().get(GROUP_ID), (String)componentUpload.getFields().get(ARTIFACT_ID), (String)componentUpload.getFields().get(VERSION), (String)componentUpload.getFields().get(PACKAGING));
                    responseData.addAssetPath(pomPath);
                }
                this.updateMetadata(repository, responseData.coordinates);
            }
            finally {
                UnitOfWork.end();
            }
            UploadResponse uploadResponse = new UploadResponse(responseData.getContent(), responseData.getAssetPaths());
            return uploadResponse;
        }
    }

    private String getBasePath(ComponentUpload componentUpload, TempBlob pom) throws IOException {
        if (pom != null) {
            return this.createBasePathFromPom(pom);
        }
        return this.createBasePath((String)componentUpload.getFields().get(GROUP_ID), (String)componentUpload.getFields().get(ARTIFACT_ID), (String)componentUpload.getFields().get(VERSION));
    }

    private void doValidation(Repository repository, String basePath, List<AssetUpload> assetUploads) {
        int i = 0;
        while (i < assetUploads.size()) {
            AssetUpload asset = assetUploads.get(i);
            StringBuilder path = new StringBuilder(basePath);
            String classifier = (String)asset.getFields().get(CLASSIFIER);
            if (!Strings2.isEmpty((String)classifier)) {
                path.append('-').append(classifier);
            }
            path.append('.').append((String)asset.getFields().get(EXTENSION));
            MavenPath mavenPath = this.parser.parsePath(path.toString());
            if (mavenPath.getCoordinates() == null) {
                throw new ValidationErrorsException(String.format("Cannot generate maven coordinate from assembled path '%s'", mavenPath.getPath()));
            }
            MavenFacet facet = (MavenFacet)repository.facet(MavenFacet.class);
            if (!this.versionPolicyValidator.validArtifactPath(facet.getVersionPolicy(), mavenPath.getCoordinates())) {
                throw new ValidationErrorsException(String.format("Version policy mismatch, cannot upload %s content to %s repositories for file '%s'", facet.getVersionPolicy().equals((Object)VersionPolicy.RELEASE) ? VersionPolicy.SNAPSHOT.name() : VersionPolicy.RELEASE.name(), facet.getVersionPolicy().name(), i));
            }
            this.ensurePermitted(repository.getName(), "maven2", mavenPath.getPath(), this.toMap(mavenPath.getCoordinates()));
            ++i;
        }
    }

    private ContentAndAssetPathResponseData createAssets(Repository repository, String basePath, List<AssetUpload> assetUploads) throws IOException {
        ContentAndAssetPathResponseData responseData = new ContentAndAssetPathResponseData();
        for (AssetUpload asset : assetUploads) {
            StringBuilder path = new StringBuilder(basePath);
            String classifier = (String)asset.getFields().get(CLASSIFIER);
            if (!Strings2.isEmpty((String)classifier)) {
                path.append('-').append(classifier);
            }
            path.append('.').append((String)asset.getFields().get(EXTENSION));
            MavenPath mavenPath = this.parser.parsePath(path.toString());
            Content content = this.storeAssetContent(repository, mavenPath, (Payload)asset.getPayload());
            if (responseData.getContent() == null) {
                responseData.setContent(content);
            }
            responseData.addAssetPath(mavenPath.getPath());
            if (responseData.getCoordinates() != null) continue;
            responseData.setCoordinates(mavenPath.getCoordinates());
        }
        return responseData;
    }

    protected Content storeAssetContent(Repository repository, MavenPath mavenPath, Payload payload) throws IOException {
        MavenFacet mavenFacet = (MavenFacet)repository.facet(MavenFacet.class);
        Content content = mavenFacet.put(mavenPath, payload);
        this.putChecksumFiles(mavenFacet, mavenPath, content);
        return content;
    }

    private void putChecksumFiles(MavenFacet facet, MavenPath path, Content content) throws IOException {
        DateTime dateTime = (DateTime)content.getAttributes().require("lastModified", DateTime.class);
        Map<HashAlgorithm, HashCode> hashes = MavenFacetUtils.getHashAlgorithmFromContent(content.getAttributes());
        MavenFacetUtils.addHashes(facet, path, hashes, dateTime);
    }

    private void updateMetadata(Repository repository, MavenPath.Coordinates coordinates) {
        if (coordinates != null) {
            ((MavenHostedFacet)repository.facet(MavenHostedFacet.class)).rebuildMetadata(coordinates.getGroupId(), coordinates.getArtifactId(), coordinates.getVersion(), false);
        } else {
            this.log.debug("Not updating metadata.xml files since coordinate could not be retrieved from path");
        }
    }

    private String createBasePath(String groupId, String artifactId, String version) {
        ArrayList parts = Lists.newArrayList((Object[])groupId.split("\\."));
        parts.addAll(Arrays.asList(artifactId, version, artifactId));
        return String.join((CharSequence)"-", String.join((CharSequence)"/", parts), version);
    }

    private String createBasePathFromPom(TempBlob tempBlob) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = tempBlob.get();){
            Model model = MavenModels.readModel(in);
            this.validatePom(model);
            return this.createBasePath(this.getGroupId(model), this.getArtifactId(model), this.getVersion(model));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String generatePom(Repository repository, String basePath, String groupId, String artifactId, String version, @Nullable String packaging) throws IOException {
        this.log.debug("Generating pom for {} {} {} with packaging {}", new Object[]{groupId, artifactId, version, packaging});
        String pom = this.mavenPomGenerator.generatePom(groupId, artifactId, version, packaging);
        MavenPath mavenPath = this.parser.parsePath(String.valueOf(basePath) + ".pom");
        this.storeAssetContent(repository, mavenPath, (Payload)new StringPayload(pom, "text/xml"));
        return mavenPath.getPath();
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            List<UploadFieldDefinition> componentFields = Arrays.asList(new UploadFieldDefinition(GROUP_ID, GROUP_ID_DISPLAY, null, false, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(ARTIFACT_ID, ARTIFACT_ID_DISPLAY, null, false, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(VERSION, false, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(GENERATE_POM, GENERATE_POM_DISPLAY, null, true, UploadFieldDefinition.Type.BOOLEAN, COMPONENT_COORDINATES_GROUP), new UploadFieldDefinition(PACKAGING, true, UploadFieldDefinition.Type.STRING, COMPONENT_COORDINATES_GROUP));
            List<UploadFieldDefinition> assetFields = Arrays.asList(new UploadFieldDefinition(CLASSIFIER, true, UploadFieldDefinition.Type.STRING), new UploadFieldDefinition(EXTENSION, false, UploadFieldDefinition.Type.STRING));
            UploadRegexMap regexMap = new UploadRegexMap("-(?:(?:\\.?\\d)+)(?:-(?:SNAPSHOT|\\d+))?(?:-(\\w+))?\\.((?:\\.?\\w)+)$", new String[]{CLASSIFIER, EXTENSION});
            this.definition = this.getDefinition("maven2", true, componentFields, assetFields, regexMap);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    private Map<String, String> toMap(MavenPath.Coordinates coordinates) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(GROUP_ID, coordinates.getGroupId());
        map.put(ARTIFACT_ID, coordinates.getArtifactId());
        map.put(VERSION, coordinates.getVersion());
        if (coordinates.getClassifier() != null) {
            map.put(CLASSIFIER, coordinates.getClassifier());
        }
        if (coordinates.getExtension() != null) {
            map.put(EXTENSION, coordinates.getExtension());
        }
        return map;
    }

    public ValidatingComponentUpload getValidatingComponentUpload(ComponentUpload componentUpload) {
        return new MavenValidatingComponentUpload(this.getDefinition(), componentUpload);
    }

    private AssetUpload findPomAsset(ComponentUpload componentUpload) {
        return componentUpload.getAssetUploads().stream().filter(asset -> "pom".equals(asset.getField(EXTENSION)) && Strings2.isBlank((String)asset.getField(CLASSIFIER))).findFirst().orElse(null);
    }

    @VisibleForTesting
    void validatePom(Model model) {
        if (model == null) {
            throw new ValidationErrorsException("The provided POM file is invalid.");
        }
        String groupId = this.getGroupId(model);
        String version = this.getVersion(model);
        String artifactId = this.getArtifactId(model);
        if (groupId == null || artifactId == null || version == null || groupId.startsWith(MAVEN_POM_PROPERTY_PREFIX) || artifactId.startsWith(MAVEN_POM_PROPERTY_PREFIX) || version.startsWith(MAVEN_POM_PROPERTY_PREFIX)) {
            throw new ValidationErrorsException(String.format("The provided POM file is invalid.  Could not retrieve valid G:A:V parameters (%s:%s:%s)", groupId, artifactId, version));
        }
    }

    private String getGroupId(Model model) {
        String groupId = model.getGroupId();
        if (groupId == null && model.getParent() != null) {
            groupId = model.getParent().getGroupId();
        }
        return groupId;
    }

    private String getArtifactId(Model model) {
        return model.getArtifactId();
    }

    private String getVersion(Model model) {
        String version = model.getVersion();
        if (version == null && model.getParent() != null) {
            version = model.getParent().getVersion();
        }
        return version;
    }

    private static class ContentAndAssetPathResponseData {
        Content content;
        List<String> assetPaths = Lists.newArrayList();
        MavenPath.Coordinates coordinates;

        private ContentAndAssetPathResponseData() {
        }

        public void setContent(Content content) {
            this.content = content;
        }

        public void setCoordinates(MavenPath.Coordinates coordinates) {
            this.coordinates = coordinates;
        }

        public void addAssetPath(String assetPath) {
            this.assetPaths.add(assetPath);
        }

        public Content getContent() {
            return this.content;
        }

        public MavenPath.Coordinates getCoordinates() {
            return this.coordinates;
        }

        public List<String> getAssetPaths() {
            return this.assetPaths;
        }

        public UploadResponse uploadResponse() {
            return new UploadResponse(this.content, this.assetPaths);
        }
    }
}

