/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.text.Strings2;

public class DigestExtractor {
    private static final int MAX_CHARS_NEEDED = 120;

    private DigestExtractor() {
    }

    @Nullable
    public static String extract(InputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (InputStreamReader isr = new InputStreamReader(ByteStreams.limit((InputStream)stream, (long)120L), StandardCharsets.UTF_8);){
                String string = DigestExtractor.extract(CharStreams.toString((Readable)isr));
                stream.close();
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            stream.close();
            throw throwable;
        }
    }

    @Nullable
    public static String extract(String input) {
        Preconditions.checkNotNull((Object)input);
        String raw = input.length() > 120 ? input.substring(0, 120) : input;
        raw = raw.indexOf(10) > -1 ? raw.substring(0, raw.indexOf(10)) : raw;
        raw = raw.trim();
        if (Strings.isNullOrEmpty((String)raw)) {
            return null;
        }
        String digest = raw.contains("=") || raw.contains(":") ? raw.split("[=:]", 2)[1].trim() : raw.split(" ", 2)[0];
        if (!DigestExtractor.isDigest(digest)) {
            digest = DigestExtractor.compress(digest);
        }
        if (!DigestExtractor.isDigest(digest)) {
            digest = DigestExtractor.compress(raw);
        }
        if (!DigestExtractor.isDigest(digest) && raw.contains(" ")) {
            digest = DigestExtractor.compress(raw.substring(0, raw.lastIndexOf(32)).trim());
        }
        if (DigestExtractor.isDigest(digest)) {
            return digest;
        }
        return null;
    }

    public static boolean isDigest(@Nullable String digest) {
        if (Strings.isNullOrEmpty((String)digest)) {
            return false;
        }
        return digest.length() >= 32 && digest.matches("^[a-f0-9]+$");
    }

    private static String compress(String digest) {
        return Strings2.lower((String)digest.replaceAll(" ", ""));
    }
}

