/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="maven2")
public class Maven2BrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<String> computeAssetPath(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (component != null) {
            List<String> path = this.computeComponentPath(asset, component);
            path.add(this.lastSegment(asset.name()));
            return path;
        }
        return super.computeAssetPath(asset, null);
    }

    public List<String> computeComponentPath(Asset asset, Component component) {
        ArrayList<String> path = new ArrayList<String>();
        if (!Strings2.isBlank((String)component.group())) {
            path.addAll(Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)component.group()));
        }
        path.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            String baseVersion = (String)component.attributes().child("maven2").get("baseVersion", String.class);
            if (!component.version().equals(baseVersion)) {
                path.add(baseVersion);
            }
            path.add(component.version());
        }
        return path;
    }
}

