/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentDirector;

@Named(value="maven2")
@Singleton
public class MavenComponentDirector
implements ComponentDirector {
    public boolean allowMoveTo(Repository destination) {
        return true;
    }

    public boolean allowMoveTo(Component component, Repository destination) {
        VersionPolicy versionPolicy = ((MavenFacet)destination.facet(MavenFacet.class)).getVersionPolicy();
        if (VersionPolicy.MIXED.equals((Object)versionPolicy)) {
            return true;
        }
        if (MavenFacetUtils.isSnapshot(component)) {
            return VersionPolicy.SNAPSHOT.equals((Object)versionPolicy);
        }
        return VersionPolicy.RELEASE.equals((Object)versionPolicy);
    }

    public boolean allowMoveFrom(Repository source) {
        return true;
    }

    public void afterMove(List<Map<String, String>> components, Repository destination) {
        destination.optionalFacet(MavenHostedFacet.class).ifPresent(f -> components.stream().map(component -> (String)component.get("group")).distinct().forEach(group -> f.rebuildMetadata((String)group, null, null, false)));
    }
}

