/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public final class MavenFacetUtils {
    public static final Comparator<Component> COMPONENT_VERSION_COMPARATOR = Comparator.comparing(o -> VersionComparator.version((String)o.version()));

    private MavenFacetUtils() {
    }

    @Nullable
    public static Component findComponent(StorageTx tx, Repository repository, MavenPath mavenPath) {
        MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
        Iterable components = tx.findComponents(Query.builder().where("group").eq((Object)coordinates.getGroupId()).and("name").eq((Object)coordinates.getArtifactId()).and("version").eq((Object)coordinates.getVersion()).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @Nullable
    public static Asset findAsset(StorageTx tx, Bucket bucket, MavenPath mavenPath) {
        return tx.findAssetWithProperty("name", (Object)mavenPath.getPath(), bucket);
    }

    public static boolean isRelease(Component component) {
        return !MavenFacetUtils.isSnapshot(component);
    }

    public static boolean isSnapshot(Component component) {
        String baseVersion = (String)component.attributes().child("maven2").get("baseVersion");
        return baseVersion != null && baseVersion.endsWith("SNAPSHOT");
    }

    public static Content createTempContent(final Path path, String contentType, Writer writer) throws IOException {
        HashMap<HashAlgorithm, HashingOutputStream> hashingStreams = new HashMap<HashAlgorithm, HashingOutputStream>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            BufferedOutputStream os = outputStream;
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                os = new HashingOutputStream(hashType.getHashAlgorithm().function(), (OutputStream)os);
                hashingStreams.put(hashType.getHashAlgorithm(), (HashingOutputStream)os);
                ++n2;
            }
            writer.write(os);
            ((OutputStream)os).flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HashMap<HashAlgorithm, HashCode> hashCodes = new HashMap<HashAlgorithm, HashCode>();
        for (Map.Entry entry : hashingStreams.entrySet()) {
            hashCodes.put((HashAlgorithm)entry.getKey(), ((HashingOutputStream)entry.getValue()).hash());
        }
        Content content = new Content((Payload)new StreamPayload(new StreamPayload.InputStreamSupplier(){

            @Nonnull
            public InputStream get() throws IOException {
                return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            }
        }, Files.size(path), contentType));
        content.getAttributes().set("lastModified", (Object)DateTime.now());
        content.getAttributes().set("hashCodesMap", hashCodes);
        AttributesMap attributesMap = content.getAttributes();
        MavenFacetUtils.mayAddETag(attributesMap, MavenFacetUtils.getHashAlgorithmFromContent(attributesMap));
        return content;
    }

    public static void mayAddETag(AttributesMap attributesMap, Map<HashAlgorithm, HashCode> hashCodes) {
        if (attributesMap.contains("etag")) {
            return;
        }
        HashCode sha1HashCode = hashCodes.get(HashAlgorithm.SHA1);
        if (sha1HashCode != null) {
            attributesMap.set("etag", (Object)("{SHA1{" + sha1HashCode + "}}"));
        }
    }

    public static Map<HashAlgorithm, HashCode> getHashAlgorithmFromContent(AttributesMap attributesMap) {
        return (Map)attributesMap.require("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
    }

    public static void putWithHashes(MavenFacet mavenFacet, MavenPath mavenPath, Content content) throws IOException {
        Map<HashAlgorithm, HashCode> hashCodes = MavenFacetUtils.getHashAlgorithmFromContent(content.getAttributes());
        DateTime now = (DateTime)content.getAttributes().require("lastModified", DateTime.class);
        mavenFacet.put(mavenPath, (Payload)content);
        MavenFacetUtils.addHashes(mavenFacet, mavenPath, hashCodes, now);
    }

    public static void addHashes(MavenFacet mavenFacet, MavenPath mavenPath, Map<HashAlgorithm, HashCode> hashCodes, DateTime now) throws IOException {
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            HashCode hashCode = hashCodes.get(hashType.getHashAlgorithm());
            if (hashCode != null) {
                Content hashContent = new Content((Payload)new StringPayload(hashCode.toString(), "text/plain"));
                hashContent.getAttributes().set("lastModified", (Object)now);
                mavenFacet.put(mavenPath.hash(hashType), (Payload)hashContent);
            }
            ++n2;
        }
    }

    public static Content putWithHashes(MavenFacet mavenFacet, MavenPath mavenPath, TempBlob tempBlob, String contentType, AttributesMap attributesMap) throws IOException {
        DateTime now = DateTime.now();
        Content result = mavenFacet.put(mavenPath, tempBlob, contentType, attributesMap);
        result.getAttributes().set("lastModified", (Object)now);
        MavenFacetUtils.addHashes(mavenFacet, mavenPath, tempBlob.getHashes(), now);
        return result;
    }

    public static boolean deleteWithHashes(MavenFacet mavenFacet, MavenPath mavenPath) throws IOException {
        ArrayList<MavenPath> paths = new ArrayList<MavenPath>(MavenPath.HashType.values().length + 1);
        paths.add(mavenPath.main());
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            paths.add(mavenPath.main().hash(hashType));
            ++n2;
        }
        return mavenFacet.delete(paths.toArray(new MavenPath[paths.size()]));
    }

    public static void deleteWithHashes(MavenFacet mavenFacet, List<MavenPath> mavenPaths) throws IOException {
        ArrayList<MavenPath> paths = new ArrayList<MavenPath>();
        for (MavenPath path : mavenPaths) {
            paths.add(path.main());
            MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
            int n = hashTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MavenPath.HashType hashType = hashTypeArray[n2];
                paths.add(path.main().hash(hashType));
                ++n2;
            }
        }
        mavenFacet.delete(paths.toArray(new MavenPath[paths.size()]));
    }

    public static Set<String> getPathWithHashes(MavenPath mavenPath) {
        HashSet<String> paths = new HashSet<String>();
        paths.add(mavenPath.main().getPath());
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            paths.add(mavenPath.main().hash(hashType).getPath());
            ++n2;
        }
        return paths;
    }

    public static interface Writer {
        public void write(OutputStream var1) throws IOException;
    }
}

