/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.maven.index.reader.ChunkReader;
import org.apache.maven.index.reader.IndexReader;
import org.apache.maven.index.reader.IndexWriter;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.RecordCompactor;
import org.apache.maven.index.reader.RecordExpander;
import org.apache.maven.index.reader.ResourceHandler;
import org.apache.maven.index.reader.Utils;
import org.apache.maven.index.reader.WritableResourceHandler;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.Attributes;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public final class MavenIndexPublisher {
    private static final Logger log = LoggerFactory.getLogger(MavenIndexPublisher.class);
    private static final String INDEX_PROPERTY_FILE = "/.index/nexus-maven-repository-index.properties";
    private static final String INDEX_MAIN_CHUNK_FILE = "/.index/nexus-maven-repository-index.gz";
    private static final String SELECT_HOSTED_ARTIFACTS = "SELECT last_updated AS lastModified, component.group AS groupId, component.name AS artifactId, component.attributes.maven2.baseVersion AS version, component.attributes.maven2.packaging AS packaging, component.attributes.maven2.pom_name AS pom_name, component.attributes.maven2.pom_description AS pom_description, attributes.maven2.classifier AS classifier, name AS path, attributes.content.last_modified AS contentLastModified, size AS contentSize, attributes.checksum.sha1 AS sha1 FROM asset WHERE bucket=:bucket AND attributes.maven2.asset_kind=:asset_kind AND component IS NOT NULL";
    private static final RecordExpander RECORD_EXPANDER = new RecordExpander();
    private static final RecordCompactor RECORD_COMPACTOR = new RecordCompactor();

    private MavenIndexPublisher() {
    }

    /*
     * Exception decompiling
     */
    public static DateTime lastPublished(Repository repository) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean prefetchIndexFiles(Repository repository) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkArgument((boolean)"proxy".equals(repository.getType().getValue()));
        return MavenIndexPublisher.prefetch(repository, INDEX_PROPERTY_FILE) && MavenIndexPublisher.prefetch(repository, INDEX_MAIN_CHUNK_FILE);
    }

    public static boolean unpublishIndexFiles(Repository repository) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        return MavenIndexPublisher.delete(repository, INDEX_PROPERTY_FILE) && MavenIndexPublisher.delete(repository, INDEX_MAIN_CHUNK_FILE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void publishMergedIndex(Repository target, List<Repository> repositories, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) throws IOException {
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkNotNull(repositories);
        try (Closer closer = Closer.create();){
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    Maven2WritableResourceHandler resourceHandler = new Maven2WritableResourceHandler(target);
                    try {
                        try (IndexWriter indexWriter = new IndexWriter((WritableResourceHandler)resourceHandler, target.getName(), false);){
                            indexWriter.writeChunk(Iterables.transform(MavenIndexPublisher.decorate(Iterables.filter((Iterable)Iterables.concat(MavenIndexPublisher.getGroupRecords(repositories, closer)), duplicateDetectionStrategy), target.getName()), arg_0 -> ((RecordCompactor)RECORD_COMPACTOR).apply(arg_0)).iterator());
                        }
                        if (resourceHandler == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (resourceHandler == null) throw throwable;
                        resourceHandler.close();
                        throw throwable;
                    }
                    resourceHandler.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                throw closer.rethrow(t);
            }
        }
    }

    public static void publishHostedIndex(Repository repository, DuplicateDetectionStrategy<Record> duplicateDetectionStrategy) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Transactional.operation.throwing(IOException.class).call(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Throwable throwable = null;
            Object var4_5 = null;
            try (Maven2WritableResourceHandler resourceHandler = new Maven2WritableResourceHandler(repository);){
                Throwable throwable2 = null;
                Object var7_10 = null;
                try (IndexWriter indexWriter = new IndexWriter((WritableResourceHandler)resourceHandler, repository.getName(), false);){
                    indexWriter.writeChunk(Iterables.transform(MavenIndexPublisher.decorate(Iterables.filter(MavenIndexPublisher.getHostedRecords(tx, repository), (Predicate)duplicateDetectionStrategy), repository.getName()), arg_0 -> ((RecordCompactor)RECORD_COMPACTOR).apply(arg_0)).iterator());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            return null;
        });
    }

    private static boolean prefetch(Repository repository, String path) throws IOException {
        MavenPath mavenPath = ((MavenFacet)repository.facet(MavenFacet.class)).getMavenPathParser().parsePath(path);
        Request getRequest = new Request.Builder().action("GET").path(path).build();
        Context context = new Context(repository, getRequest);
        context.getAttributes().set(MavenPath.class, (Object)mavenPath);
        return ((ProxyFacet)repository.facet(ProxyFacet.class)).get(context) != null;
    }

    private static boolean delete(Repository repository, String path) throws IOException {
        MavenFacet mavenFacet = (MavenFacet)repository.facet(MavenFacet.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(path);
        return mavenFacet.delete(mavenPath);
    }

    private static Iterable<Record> getHostedRecords(StorageTx tx, Repository repository) throws IOException {
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        sqlParams.put("bucket", AttachedEntityHelper.id((Entity)tx.findBucket(repository)));
        sqlParams.put("asset_kind", Attributes.AssetKind.ARTIFACT.name());
        return Iterables.transform((Iterable)tx.browse(SELECT_HOSTED_ARTIFACTS, sqlParams), document -> MavenIndexPublisher.toRecord((MavenFacet)repository.facet(MavenFacet.class), document));
    }

    private static Iterable<Iterable<Record>> getGroupRecords(List<Repository> repositories, Closer closer) throws IOException {
        UnitOfWork paused = UnitOfWork.pause();
        try {
            ArrayList<Iterable<Record>> records = new ArrayList<Iterable<Record>>();
            for (Repository repository : repositories) {
                UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
                try {
                    try {
                        ResourceHandler resourceHandler = (ResourceHandler)closer.register((Closeable)((Object)new Maven2WritableResourceHandler(repository)));
                        IndexReader indexReader = (IndexReader)closer.register((Closeable)new IndexReader(null, resourceHandler));
                        ChunkReader chunkReader = (ChunkReader)closer.register((Closeable)((ChunkReader)indexReader.iterator().next()));
                        records.add(Iterables.filter((Iterable)Iterables.transform((Iterable)chunkReader, arg_0 -> ((RecordExpander)RECORD_EXPANDER).apply(arg_0)), (Predicate)new RecordTypeFilter(Record.Type.ARTIFACT_ADD)));
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                finally {
                    UnitOfWork.end();
                }
            }
            ArrayList<Iterable<Record>> arrayList = records;
            return arrayList;
        }
        finally {
            UnitOfWork.resume((UnitOfWork)paused);
        }
    }

    private static Record toRecord(MavenFacet mavenFacet, ODocument document) {
        Preconditions.checkNotNull((Object)document);
        String path = (String)document.field("path", String.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(path);
        Preconditions.checkArgument((mavenPath.getCoordinates() != null && !mavenPath.isSubordinate() ? 1 : 0) != 0);
        Record record = new Record(Record.Type.ARTIFACT_ADD, new HashMap());
        record.put(Record.REC_MODIFIED, (Object)((Long)document.field("lastModified", Long.class)));
        record.put(Record.GROUP_ID, (Object)((String)document.field("groupId", String.class)));
        record.put(Record.ARTIFACT_ID, (Object)((String)document.field("artifactId", String.class)));
        record.put(Record.VERSION, (Object)((String)document.field("version", String.class)));
        record.put(Record.CLASSIFIER, (Object)((String)document.field("classifier", String.class)));
        String packaging = (String)document.field("packaging", String.class);
        if (packaging != null) {
            record.put(Record.PACKAGING, (Object)packaging);
        } else {
            record.put(Record.PACKAGING, (Object)MavenIndexPublisher.pathExtension(mavenPath.getFileName()));
        }
        record.put(Record.NAME, (Object)MavenIndexPublisher.defStr((String)document.field("pom_name", String.class), ""));
        record.put(Record.DESCRIPTION, (Object)MavenIndexPublisher.defStr((String)document.field("pom_description", String.class), ""));
        MavenIndexPublisher.checkExistence(record, (Record.EntryKey<Boolean>)Record.HAS_SOURCES, mavenPath.locate("jar", "sources"), mavenFacet);
        MavenIndexPublisher.checkExistence(record, (Record.EntryKey<Boolean>)Record.HAS_JAVADOC, mavenPath.locate("jar", "javadoc"), mavenFacet);
        MavenIndexPublisher.checkExistence(record, (Record.EntryKey<Boolean>)Record.HAS_SIGNATURE, mavenPath.signature(MavenPath.SignatureType.GPG), mavenFacet);
        record.put(Record.FILE_EXTENSION, (Object)MavenIndexPublisher.pathExtension(mavenPath.getFileName()));
        record.put(Record.FILE_MODIFIED, (Object)((Long)document.field("contentLastModified", Long.class)));
        record.put(Record.FILE_SIZE, (Object)((Long)document.field("contentSize", Long.class)));
        record.put(Record.SHA1, (Object)((String)document.field("sha1", String.class)));
        return record;
    }

    private static void checkExistence(Record record, Record.EntryKey<Boolean> key, MavenPath tocheck, MavenFacet mavenFacet) {
        record.put(key, (Object)mavenFacet.exists(tocheck));
    }

    private static String pathExtension(String path) {
        int lastDot;
        String filename = path.toLowerCase(Locale.ENGLISH);
        if (filename.endsWith("tar.gz")) {
            return "tar.gz";
        }
        if (filename.endsWith("tar.bz2")) {
            return "tar.bz2";
        }
        int lastSep = filename.lastIndexOf(47);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return null;
    }

    private static Iterable<Record> decorate(Iterable<Record> iterable, String repositoryName) {
        TreeSet allGroups = new TreeSet();
        TreeSet rootGroups = new TreeSet();
        return Iterables.transform((Iterable)Iterables.concat(Collections.singletonList(Utils.descriptor((String)repositoryName)), iterable, Collections.singletonList(Utils.allGroups(allGroups)), Collections.singletonList(Utils.rootGroups(rootGroups))), rec -> {
            if (Record.Type.DESCRIPTOR == rec.getType()) {
                return rec;
            }
            if (Record.Type.ALL_GROUPS == rec.getType()) {
                return Utils.allGroups((Collection)allGroups);
            }
            if (Record.Type.ROOT_GROUPS == rec.getType()) {
                return Utils.rootGroups((Collection)rootGroups);
            }
            String groupId = (String)rec.get(Record.GROUP_ID);
            if (groupId != null) {
                allGroups.add(groupId);
                rootGroups.add(Utils.rootGroup((String)groupId));
            }
            return rec;
        });
    }

    private static String defStr(String s, String defaultValue) {
        if (Strings2.isBlank((String)s)) {
            return defaultValue;
        }
        return s;
    }

    private static class Maven2WritableResource
    implements WritableResourceHandler.WritableResource {
        private final MavenPath mavenPath;
        private final MavenFacet mavenFacet;
        private final String contentType;
        private Path path;

        private Maven2WritableResource(MavenPath mavenPath, MavenFacet mavenFacet, String contenType) {
            this.mavenPath = mavenPath;
            this.mavenFacet = mavenFacet;
            this.contentType = contenType;
            this.path = null;
        }

        public InputStream read() throws IOException {
            Content content = this.mavenFacet.get(this.mavenPath);
            if (content != null) {
                return content.openInputStream();
            }
            return null;
        }

        public OutputStream write() throws IOException {
            this.path = File.createTempFile(this.mavenPath.getFileName(), "tmp").toPath();
            return new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0]));
        }

        public void close() throws IOException {
            if (this.path != null) {
                this.mavenFacet.put(this.mavenPath, (Payload)new StreamPayload(new StreamPayload.InputStreamSupplier(){

                    @Nonnull
                    public InputStream get() throws IOException {
                        return new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                    }
                }, Files.size(this.path), this.contentType));
                Files.delete(this.path);
                this.path = null;
            }
        }
    }

    static class Maven2WritableResourceHandler
    implements WritableResourceHandler {
        private final MavenFacet mavenFacet;

        Maven2WritableResourceHandler(Repository repository) {
            this.mavenFacet = (MavenFacet)repository.facet(MavenFacet.class);
        }

        public Maven2WritableResource locate(String name) throws IOException {
            String contentType;
            if (name.endsWith(".properties")) {
                contentType = "text/plain";
            } else if (name.endsWith(".gz")) {
                contentType = "application/gzip";
            } else {
                throw new IllegalArgumentException("Unsupported MI index resource:" + name);
            }
            MavenPath mavenPath = this.mavenFacet.getMavenPathParser().parsePath("/.index/" + name);
            return new Maven2WritableResource(mavenPath, this.mavenFacet, contentType);
        }

        public void close() throws IOException {
        }
    }

    private static class RecordTypeFilter
    implements Predicate<Record> {
        private final List<Record.Type> allowedTypes;

        public RecordTypeFilter(Record.Type ... allowedTypes) {
            this.allowedTypes = Arrays.asList(allowedTypes);
        }

        public boolean apply(Record input) {
            return this.allowedTypes.contains(input.getType());
        }
    }
}

