/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.elasticsearch.search.lookup.SourceLookup;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.security.VariableResolverAdapterSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.selector.VariableSourceBuilder;

@Named(value="maven2")
public class MavenVariableResolverAdapter
extends VariableResolverAdapterSupport
implements VariableResolverAdapter {
    private final MavenPathParser mavenPathParser;

    @Inject
    public MavenVariableResolverAdapter(@Named(value="maven2") MavenPathParser mavenPathParser) {
        this.mavenPathParser = (MavenPathParser)Preconditions.checkNotNull((Object)mavenPathParser);
    }

    protected void addFromRequest(VariableSourceBuilder builder, Request request) {
        this.addMavenCoordinates(builder, request.getPath());
    }

    protected void addFromDocument(VariableSourceBuilder builder, ODocument document) {
        this.addMavenCoordinates(builder, (String)document.field("name", String.class));
    }

    protected void addFromAsset(VariableSourceBuilder builder, Asset asset) {
        this.addMavenCoordinates(builder, asset.name());
    }

    protected void addFromSourceLookup(VariableSourceBuilder builder, SourceLookup sourceLookup, Map<String, Object> asset) {
        this.addMavenCoordinates(builder, (String)asset.get("name"));
    }

    private void addMavenCoordinates(VariableSourceBuilder builder, String path) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)path);
        MavenPath.Coordinates coords = this.mavenPathParser.parsePath(path).getCoordinates();
        if (coords != null) {
            HashMap<String, String> coordMap = new HashMap<String, String>();
            coordMap.put("groupId", coords.getGroupId());
            coordMap.put("artifactId", coords.getArtifactId());
            coordMap.put("version", coords.getBaseVersion());
            coordMap.put("extension", coords.getExtension());
            coordMap.put("classifier", coords.getClassifier() == null ? "" : coords.getClassifier());
            this.addCoordinates(builder, coordMap);
        }
    }
}

