/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.query.OResultSet;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.RemoveSnapshotsFacet;
import org.sonatype.nexus.repository.maven.VersionPolicy;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.repository.maven.tasks.RemoveSnapshotsConfig;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class RemoveSnapshotsFacetImpl
extends FacetSupport
implements RemoveSnapshotsFacet {
    private static final String GAVS_WITH_SNAPSHOTS = "SELECT group, name, attributes.maven2.baseVersion AS baseVersion, count(*) AS cnt FROM component WHERE bucket=:bucket AND attributes.maven2.baseVersion LIKE '%-SNAPSHOT' GROUP BY group, name, attributes.maven2.baseVersion";
    private static final String COMPONENTS_FOR_GABV = "LET $records = (SELECT FROM component WHERE group = ? AND name=?);SELECT FROM $records WHERE (    (bucket=? AND attributes.maven2.baseVersion = ?)    OR (attributes.maven2.baseVersion = ?));";
    private final long batchSize;
    private final ComponentEntityAdapter componentEntityAdapter;
    private final Type groupType;

    @Inject
    public RemoveSnapshotsFacetImpl(ComponentEntityAdapter componentEntityAdapter, @Named(value="group") Type groupType, @Named(value="${nexus.removeSnapshots.batchSize:-500}") long batchSize) {
        this.componentEntityAdapter = (ComponentEntityAdapter)Preconditions.checkNotNull((Object)componentEntityAdapter);
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
        this.batchSize = batchSize;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void removeSnapshots(RemoveSnapshotsConfig config) {
        Repository repository = this.getRepository();
        String repositoryName = repository.getName();
        this.log.info("Beginning snapshot removal on repository '{}' with configuration: {}", (Object)repositoryName, (Object)config);
        UnitOfWork.beginBatch((com.google.common.base.Supplier)((StorageFacet)this.facet(StorageFacet.class)).txSupplier());
        HashSet<GAV> metadataUpdateRequired = new HashSet<GAV>();
        try {
            if (this.groupType.equals((Object)repository.getType())) {
                this.processGroup((MavenGroupFacet)repository.facet(MavenGroupFacet.class), config);
            } else {
                metadataUpdateRequired.addAll(this.processRepository(repository, config));
            }
        }
        finally {
            UnitOfWork.end();
        }
        if (!repository.optionalFacet(ProxyFacet.class).isPresent()) {
            this.log.info("Updating metadata on repository '{}'", (Object)repositoryName);
            ProgressLogIntervalHelper intervalLogger = new ProgressLogIntervalHelper(this.log, 60);
            int processed = 0;
            for (GAV gav : metadataUpdateRequired) {
                Optional mavenHostedFacet = repository.optionalFacet(MavenHostedFacet.class);
                if (!mavenHostedFacet.isPresent()) continue;
                ((MavenHostedFacet)mavenHostedFacet.get()).deleteMetadata(gav.group, gav.name, gav.baseVersion);
                intervalLogger.info("Elapsed time: {}, updated metadata for {} GAVs", new Object[]{intervalLogger.getElapsed(), ++processed});
            }
            intervalLogger.flush();
        } else {
            this.log.info("Skipping metadata updates on proxy repository '{}'", (Object)repositoryName);
        }
        this.log.info("Completed snapshot removal on repository '{}'", (Object)repositoryName);
    }

    private void processGroup(MavenGroupFacet groupFacet, RemoveSnapshotsConfig config) {
        groupFacet.members().stream().filter(member -> RemoveSnapshotsFacetImpl.isSnapshotRepo(member) || this.groupType.equals((Object)member.getType())).forEach(member -> ((RemoveSnapshotsFacet)member.facet(RemoveSnapshotsFacet.class)).removeSnapshots(config));
    }

    @TransactionalDeleteBlob
    protected Collection<GAV> processRepository(Repository repository, RemoveSnapshotsConfig config) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        this.log.info("Begin processing snapshots in repository '{}'", (Object)repository.getName());
        HashSet snapshotCandidates = Sets.newHashSet(this.findSnapshotCandidates(tx, repository));
        this.log.info("Found {} snapshot GAVs to analyze", (Object)snapshotCandidates.size());
        HashSet<GAV> gavsWithDeletions = new HashSet<GAV>();
        ProgressLogIntervalHelper intervalLogger = new ProgressLogIntervalHelper(this.log, 60);
        long deleted = 0L;
        long processed = 0L;
        for (GAV snapshotCandidate : snapshotCandidates) {
            this.log.debug("Processing GAV = {}", (Object)snapshotCandidate);
            HashSet components = Sets.newHashSet(this.findComponentsForGav(tx, repository, snapshotCandidate));
            if (components.isEmpty()) continue;
            Set<Component> toDelete = this.getSnapshotsToDelete(config, components);
            if (!toDelete.isEmpty()) {
                this.log.debug("Found {} components to remove for GAV = {}", (Object)toDelete.size(), (Object)snapshotCandidate);
                gavsWithDeletions.add(snapshotCandidate);
                for (Component component : toDelete) {
                    this.log.debug("Deleting component: {}", (Object)component);
                    tx.deleteComponent(component);
                    if (!this.maybeCommit(tx, ++deleted)) continue;
                    intervalLogger.info("Elapsed time: {}, GAVs processed: {}, snapshots deleted: {}", new Object[]{intervalLogger.getElapsed(), processed, deleted});
                }
            }
            ++processed;
        }
        this.log.debug("Committing final batch delete");
        tx.commit();
        tx.begin();
        intervalLogger.flush();
        DateTime olderThan = DateTime.now().minusDays(Math.max(config.getSnapshotRetentionDays(), 0));
        this.log.info("Elapsed time: {}, deleted {} components from {} distinct GAVs", new Object[]{intervalLogger.getElapsed(), deleted, gavsWithDeletions.size()});
        this.log.info("Finished processing snapshots with more than {} versions created before {}", (Object)config.getMinimumRetained(), (Object)olderThan);
        return gavsWithDeletions;
    }

    @VisibleForTesting
    Set<Component> getSnapshotsToDelete(RemoveSnapshotsConfig config, Set<Component> components) {
        HashSet<Component> snapshotsToDelete;
        Supplier<Stream> streamSupplier = () -> components.stream().filter(MavenFacetUtils::isSnapshot).sorted(MavenFacetUtils.COMPONENT_VERSION_COMPARATOR.reversed());
        DateTime olderThan = DateTime.now().minusDays(Math.max(config.getSnapshotRetentionDays(), 0));
        AtomicInteger keep = new AtomicInteger();
        Set<Object> set = snapshotsToDelete = config.getMinimumRetained() == -1 ? new HashSet<Component>() : streamSupplier.get().filter(component -> keep.incrementAndGet() > config.getMinimumRetained()).filter(component -> olderThan.isAfter((ReadableInstant)component.lastUpdated())).collect(Collectors.toSet());
        if (config.getRemoveIfReleased() && components.stream().anyMatch(MavenFacetUtils::isRelease)) {
            DateTime gracePeriod = DateTime.now().minusDays(Math.max(config.getGracePeriod(), 0));
            Set releasedSnapshotsToDelete = streamSupplier.get().filter(component -> gracePeriod.isAfter((ReadableInstant)component.lastUpdated())).collect(Collectors.toSet());
            snapshotsToDelete.addAll(releasedSnapshotsToDelete);
        }
        return snapshotsToDelete;
    }

    private boolean maybeCommit(StorageTx tx, long deleted) {
        if (deleted % this.batchSize == 0L) {
            tx.commit();
            tx.begin();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    Iterable<Component> findComponentsForGav(StorageTx tx, Repository repository, GAV gav) {
        Bucket bucket = tx.findBucket(repository);
        ORID bucketId = AttachedEntityHelper.id((Entity)bucket);
        String releaseVersion = gav.baseVersion.replace("-SNAPSHOT", "");
        OResultSet result = (OResultSet)tx.getDb().command((OCommandRequest)new OCommandScript("sql", COMPONENTS_FOR_GABV)).execute(new Object[]{gav.group, gav.name, bucketId, gav.baseVersion, releaseVersion});
        return result.stream().map(arg_0 -> ((ComponentEntityAdapter)this.componentEntityAdapter).readEntity(arg_0)).collect(Collectors.toList());
    }

    @VisibleForTesting
    Set<GAV> findSnapshotCandidates(StorageTx tx, Repository repository) {
        this.log.info(TaskLoggingMarkers.PROGRESS, "Searching for GAVS with snapshots that qualify for deletion on repository '{}'", (Object)repository.getName());
        Bucket bucket = tx.findBucket(repository);
        OResultSet result = (OResultSet)tx.getDb().command((OCommandRequest)new OSQLSynchQuery(GAVS_WITH_SNAPSHOTS)).execute(new Object[]{AttachedEntityHelper.id((Entity)bucket)});
        return result.stream().map(doc -> {
            String group = (String)doc.field("group", String.class);
            String name = (String)doc.field("name", String.class);
            String baseVersion = (String)doc.field("baseVersion", String.class);
            Integer count = (Integer)doc.field("cnt", Integer.class);
            return new GAV(group, name, baseVersion, count);
        }).collect(Collectors.toSet());
    }

    private static boolean isSnapshotRepo(Repository member) {
        return ((MavenFacet)member.facet(MavenFacet.class)).getVersionPolicy() != VersionPolicy.RELEASE;
    }

    static final class GAV {
        final String group;
        final String name;
        final String baseVersion;
        final int count;

        public GAV(String group, String name, String baseVersion, int count) {
            this.group = group;
            this.name = name;
            this.baseVersion = baseVersion;
            this.count = count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GAV gav = (GAV)o;
            return this.count == gav.count && Objects.equal((Object)this.group, (Object)gav.group) && Objects.equal((Object)this.name, (Object)gav.name) && Objects.equal((Object)this.baseVersion, (Object)gav.baseVersion);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.name, this.baseVersion, this.count});
        }

        public String toString() {
            return "GAV{group='" + this.group + '\'' + ", name='" + this.name + '\'' + ", baseVersion='" + this.baseVersion + '\'' + ", count=" + this.count + '}';
        }
    }
}

