/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.filter;

import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.maven.index.reader.Record;
import org.sonatype.nexus.common.filter.ScalableBloomFilter;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.utils.RecordUtils;

public class BloomFilterDuplicateDetectionStrategy
implements DuplicateDetectionStrategy<Record> {
    private static double MAX_PROBABILITY = 1.0E-16;
    private static int BLOOM_FILTER_SIZE = 1000000;
    private final ScalableBloomFilter<String> bloomFilter = new ScalableBloomFilter(Funnels.stringFunnel((Charset)StandardCharsets.UTF_8), BLOOM_FILTER_SIZE, MAX_PROBABILITY);

    public boolean apply(Record record) {
        return this.bloomFilter.put((Object)RecordUtils.gavceForRecord(record));
    }
}

