/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.filter;

import java.util.UUID;
import org.apache.maven.index.reader.Record;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.utils.RecordUtils;

public class DiskBackedDuplicateDetectionStrategy
implements DuplicateDetectionStrategy<Record> {
    public static final String CACHE_NAME = "duplicate-detection-cache";
    private final Cache<String, String> map;
    private final CacheManager cacheManager;

    public DiskBackedDuplicateDetectionStrategy(ApplicationDirectories directories, int maxHeapGb, int maxDiskGb) {
        String randomDirectory = UUID.randomUUID().toString();
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().with(CacheManagerBuilder.persistence((String)(String.valueOf(directories.getTemporaryDirectory().getPath()) + "/" + randomDirectory))).withCache(CACHE_NAME, (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, String.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap((long)maxHeapGb, (ResourceUnit)MemoryUnit.GB).disk((long)maxDiskGb, MemoryUnit.GB))).build(true);
        this.map = this.cacheManager.getCache(CACHE_NAME, String.class, String.class);
    }

    public boolean apply(Record record) {
        String gavce = RecordUtils.gavceForRecord(record);
        if (this.map.containsKey((Object)gavce)) {
            return false;
        }
        this.map.put((Object)gavce, (Object)"");
        return true;
    }

    @Override
    public void close() {
        this.cacheManager.close();
    }
}

