/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.index.reader.Record;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.maven.MavenIndexFacet;
import org.sonatype.nexus.repository.maven.internal.MavenIndexFacetSupport;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategyProvider;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class IndexGroupFacet
extends MavenIndexFacetSupport {
    private final DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider;

    @Inject
    public IndexGroupFacet(DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider) {
        this.duplicateDetectionStrategyProvider = (DuplicateDetectionStrategyProvider)((Object)Preconditions.checkNotNull((Object)((Object)duplicateDetectionStrategyProvider)));
    }

    @Override
    public void publishIndex() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Object strategy = this.duplicateDetectionStrategyProvider.get();){
                List leafMembers = ((GroupFacet)this.facet(GroupFacet.class)).leafMembers();
                ArrayList<String> withoutIndex = new ArrayList<String>();
                Iterator ri = leafMembers.iterator();
                while (ri.hasNext()) {
                    Repository repository = (Repository)ri.next();
                    if (((MavenIndexFacet)repository.facet(MavenIndexFacet.class)).lastPublished() != null) continue;
                    withoutIndex.add(repository.getName());
                    ri.remove();
                }
                if (!withoutIndex.isEmpty()) {
                    this.log.info("Following members of group {} have no index, will not participate in merged index: {}", (Object)this.getRepository().getName(), withoutIndex);
                }
                MavenIndexPublisher.publishMergedIndex(this.getRepository(), leafMembers, (DuplicateDetectionStrategy<Record>)strategy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            UnitOfWork.end();
        }
    }
}

