/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.ByteStreams;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.group.ArchetypeCatalogMerger;
import org.sonatype.nexus.repository.maven.internal.group.RepositoryMetadataMerger;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.MissingBlobException;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.thread.io.StreamCopier;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class MavenGroupFacet
extends GroupFacetImpl {
    private final RepositoryMetadataMerger repositoryMetadataMerger = new RepositoryMetadataMerger();
    private final ArchetypeCatalogMerger archetypeCatalogMerger = new ArchetypeCatalogMerger();
    private MavenFacet mavenFacet;

    @Inject
    public MavenGroupFacet(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType) {
        super(repositoryManager, constraintViolationFactory, groupType);
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenFacet = (MavenFacet)this.facet(MavenFacet.class);
    }

    @Nullable
    public Content getCached(MavenPath mavenPath) throws IOException {
        this.checkMergeHandled(mavenPath);
        Content content = this.mavenFacet.get(mavenPath);
        if (mavenPath.isHash()) {
            return content;
        }
        return !this.isStale(content) ? content : null;
    }

    @Nullable
    public Content mergeAndCache(MavenPath mavenPath, Map<Repository, Response> responses) throws IOException {
        return this.merge(mavenPath, responses, this::createTempBlob, (T tempBlob, String contentType) -> {
            this.log.trace("Caching merged content");
            return this.cache(mavenPath, (TempBlob)tempBlob, contentType);
        });
    }

    @Nullable
    public Content mergeWithoutCaching(MavenPath mavenPath, Map<Repository, Response> responses) throws IOException {
        return this.merge(mavenPath, responses, Function.identity(), (T in, String contentType) -> new Content((Payload)new BytesPayload(ByteStreams.toByteArray((InputStream)in), contentType)));
    }

    @Nullable
    private <T extends Closeable> Content merge(MavenPath mavenPath, Map<Repository, Response> responses, Function<InputStream, T> streamFunction, ContentFunction<T> contentFunction) throws IOException {
        this.checkMergeHandled(mavenPath);
        Preconditions.checkArgument((!mavenPath.isSubordinate() ? 1 : 0) != 0, (String)"Only main content handled, not hash or signature: %s", (Object)mavenPath);
        LinkedHashMap contents = Maps.newLinkedHashMap();
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            Response response;
            if (entry.getValue().getStatus().getCode() != 200 || !((response = entry.getValue()).getPayload() instanceof Content)) continue;
            contents.put(entry.getKey(), (Content)response.getPayload());
        }
        if (contents.isEmpty()) {
            this.log.trace("No 200 OK responses to merge");
            return null;
        }
        try (Closeable data = null;){
            String contentType = null;
            if (this.mavenFacet.getMavenPathParser().isRepositoryMetadata(mavenPath)) {
                data = (Closeable)this.merge(this.repositoryMetadataMerger::merge, mavenPath, contents, streamFunction);
                contentType = "application/xml";
            } else if (mavenPath.getFileName().equals("archetype-catalog.xml")) {
                data = (Closeable)this.merge(this.archetypeCatalogMerger::merge, mavenPath, contents, streamFunction);
                contentType = "application/xml";
            }
            if (data == null) {
                this.log.trace("No content resulted out of merge");
                return null;
            }
            Content content = contentFunction.apply(data, contentType);
            return content;
        }
    }

    private <T> T merge(MetadataMerger merger, MavenPath mavenPath, LinkedHashMap<Repository, Content> contents, Function<InputStream, T> streamFunction) {
        return (T)new StreamCopier(outputStream -> merger.merge((OutputStream)outputStream, mavenPath, contents), streamFunction).read();
    }

    private TempBlob createTempBlob(InputStream inputStream) {
        StorageFacet storageFacet = (StorageFacet)this.getRepository().facet(StorageFacet.class);
        List hashAlgorithms = Arrays.stream(MavenPath.HashType.values()).map(MavenPath.HashType::getHashAlgorithm).collect(Collectors.toList());
        return storageFacet.createTempBlob(inputStream, hashAlgorithms);
    }

    private void checkMergeHandled(MavenPath mavenPath) {
        Preconditions.checkArgument((this.mavenFacet.getMavenPathParser().isRepositoryMetadata(mavenPath) || mavenPath.getFileName().equals("archetype-catalog.xml") ? 1 : 0) != 0, (String)"Not handled by Maven2GroupFacet merge: %s", (Object)mavenPath);
    }

    private Content cache(MavenPath mavenPath, TempBlob tempBlob, String contentType) throws IOException {
        AttributesMap attributesMap = new AttributesMap();
        this.maintainCacheInfo(attributesMap);
        MavenFacetUtils.mayAddETag(attributesMap, tempBlob.getHashes());
        try {
            return this.doCache(mavenPath, tempBlob, contentType, attributesMap);
        }
        catch (ONeedRetryException | ORecordDuplicatedException | MissingBlobException e) {
            this.log.debug("Conflict caching merged content {} : {}", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
        }
        catch (Exception e) {
            this.log.warn("Problem caching merged content {} : {}", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
        }
        this.invalidatePath(mavenPath);
        Throwable throwable = null;
        Object var6_9 = null;
        try (InputStream in = tempBlob.get();){
            return new Content((Payload)new BytesPayload(ByteStreams.toByteArray((InputStream)in), contentType));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Transactional
    protected Content doCache(MavenPath mavenPath, TempBlob tempBlob, String contentType, AttributesMap attributesMap) throws IOException {
        return MavenFacetUtils.putWithHashes(this.mavenFacet, mavenPath, tempBlob, contentType, attributesMap);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        if (event.isLocal() && event.getComponentId() == null && this.member(event.getRepositoryName())) {
            String path = event.getAsset().name();
            MavenPath mavenPath = this.mavenFacet.getMavenPathParser().parsePath(path);
            if (!mavenPath.isHash()) {
                UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
                try {
                    this.evictCache(mavenPath, event instanceof AssetDeletedEvent);
                }
                finally {
                    UnitOfWork.end();
                }
            }
        }
    }

    private void evictCache(MavenPath mavenPath, boolean delete) {
        if (delete) {
            try {
                this.deletePath(mavenPath);
                return;
            }
            catch (ONeedRetryException | MissingBlobException e) {
                this.log.debug("Conflict deleting cached content {} : {}, will invalidate instead", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
            }
            catch (Exception e) {
                this.log.warn("Problem deleting cached content {} : {}, will invalidate instead", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
            }
        }
        this.invalidatePath(mavenPath);
    }

    @Transactional(swallow={ORecordNotFoundException.class})
    protected void deletePath(MavenPath mavenPath) throws IOException {
        MavenFacetUtils.deleteWithHashes(this.mavenFacet, mavenPath);
    }

    private void invalidatePath(MavenPath mavenPath) {
        try {
            this.doInvalidate(mavenPath);
        }
        catch (Exception e) {
            this.log.warn("Problem invalidating cached content {} : {}", new Object[]{this.getRepository().getName(), mavenPath.getPath(), e});
        }
    }

    @Transactional(retryOn={ONeedRetryException.class}, swallow={ORecordNotFoundException.class})
    protected void doInvalidate(MavenPath mavenPath) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = MavenFacetUtils.findAsset(tx, tx.findBucket(this.getRepository()), mavenPath.main());
        if (asset != null && CacheInfo.invalidateAsset((Asset)asset)) {
            tx.saveAsset(asset);
        }
    }

    @FunctionalInterface
    private static interface ContentFunction<T> {
        public Content apply(T var1, String var2) throws IOException;
    }

    static interface MetadataMerger {
        public void merge(OutputStream var1, MavenPath var2, LinkedHashMap<Repository, Content> var3);
    }
}

