/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.group;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.HasFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.group.MavenGroupFacet;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.storage.RetryDeniedException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named
public class MergingGroupHandler
extends GroupHandler {
    private static final Predicate<Repository> PROXY_OR_GROUP = Predicates.or((Predicate)new HasFacet(ProxyFacet.class), (Predicate)new HasFacet(GroupFacet.class));

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Content content;
        Iterable proxiesOrGroups;
        MavenPath mavenPath = (MavenPath)context.getAttributes().require(MavenPath.class);
        MavenGroupFacet groupFacet = (MavenGroupFacet)context.getRepository().facet(MavenGroupFacet.class);
        this.log.trace("Incoming request for {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
        List members = groupFacet.members();
        Object passThroughResponses = ImmutableMap.of();
        if (!mavenPath.isHash() && (proxiesOrGroups = Iterables.filter((Iterable)members, PROXY_OR_GROUP)).iterator().hasNext()) {
            passThroughResponses = this.getAll(context, proxiesOrGroups, dispatched);
        }
        try {
            content = groupFacet.getCached(mavenPath);
            if (content != null) {
                this.log.trace("Serving cached content {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
                return HttpResponses.ok((Payload)content);
            }
        }
        catch (RetryDeniedException e) {
            this.log.debug("Conflict fetching cached content {} : {}", new Object[]{context.getRepository().getName(), mavenPath.getPath(), e});
        }
        if (!mavenPath.isHash()) {
            LinkedHashMap remainingResponses = this.getAll(context, members, dispatched);
            LinkedHashMap<Repository, Response> responses = new LinkedHashMap<Repository, Response>();
            for (Repository member : members) {
                Response response = (Response)passThroughResponses.get(member);
                if (response == null) {
                    response = (Response)remainingResponses.get(member);
                }
                if (response == null) continue;
                responses.put(member, response);
            }
            content = groupFacet.mergeAndCache(mavenPath, responses);
            if (content != null) {
                this.log.trace("Responses merged {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
                return HttpResponses.ok((Payload)content);
            }
            this.log.trace("Not found respone to merge {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
            return HttpResponses.notFound();
        }
        this.log.trace("Outbound request for hash {} : {}", (Object)context.getRepository().getName(), (Object)mavenPath.getPath());
        return HttpResponses.notFound();
    }
}

