/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.group;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.view.Content;

public class RepositoryMetadataMerger
extends ComponentSupport {
    private static final Comparator<Plugin> pluginComparator = new Comparator<Plugin>(){

        @Override
        public int compare(Plugin p1, Plugin p2) {
            return p1.getArtifactId().compareTo(p2.getArtifactId());
        }
    };

    public void merge(OutputStream outputStream, MavenPath mavenPath, Map<Repository, Content> contents) {
        this.log.debug("Merge metadata for {}", (Object)mavenPath.getPath());
        ArrayList<Envelope> metadatas = new ArrayList<Envelope>(contents.size());
        try {
            for (Map.Entry<Repository, Content> entry : contents.entrySet()) {
                this.addReadMetadata(mavenPath, metadatas, entry);
            }
            Metadata mergedMetadata = this.merge(metadatas);
            if (mergedMetadata == null) {
                return;
            }
            MavenModels.writeMetadata(outputStream, mergedMetadata);
        }
        catch (IOException e) {
            this.log.error("Unable to merge {}", (Object)mavenPath, (Object)e);
        }
    }

    private void addReadMetadata(MavenPath mavenPath, List<Envelope> metadatas, Map.Entry<Repository, Content> entry) throws IOException {
        String origin = String.valueOf(entry.getKey().getName()) + " @ " + mavenPath.getPath();
        try {
            Metadata metadata = MavenModels.readMetadata(entry.getValue().openInputStream());
            if (metadata == null) {
                this.log.debug("Corrupted repository metadata: {}, source: {}", (Object)origin, (Object)entry.getValue());
                return;
            }
            metadatas.add(new Envelope(origin, metadata));
        }
        catch (IOException e) {
            this.log.debug("Error downloading repository metadata: {}, source: {}", (Object)origin, (Object)entry.getValue());
            throw new IOException("Error downloading repository metadata for " + origin + ": " + e.getMessage(), e);
        }
    }

    @Nonnull
    private static String nullOrEmptyStringFilter(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return "";
        }
        return str.trim();
    }

    private static <E> void nullElementFilter(List<E> list) {
        Iterator<E> i = list.iterator();
        while (i.hasNext()) {
            E element = i.next();
            if (element != null && !Objects.equals(element, "null")) continue;
            i.remove();
        }
    }

    public boolean metadataEquals(Metadata md1, Metadata md2) {
        Preconditions.checkNotNull((Object)md1);
        Preconditions.checkNotNull((Object)md2);
        return Objects.equals(md1.getGroupId(), md2.getGroupId()) && Objects.equals(md1.getArtifactId(), md2.getArtifactId()) && Objects.equals(md1.getVersion(), md2.getVersion()) && this.versioningEquals(md1.getVersioning(), md2.getVersioning()) && this.pluginsEquals(md1.getPlugins(), md2.getPlugins());
    }

    private boolean versioningEquals(@Nullable Versioning v1, @Nullable Versioning v2) {
        if (v1 == null || v2 == null) {
            return v1 == v2;
        }
        return Objects.equals(v1.getLatest(), v2.getLatest()) && Objects.equals(v1.getRelease(), v2.getRelease()) && this.snapshotEquals(v1.getSnapshot(), v2.getSnapshot()) && Objects.equals(v1.getVersions(), v2.getVersions()) && this.snapshotVersionsEquals(v1.getSnapshotVersions(), v2.getSnapshotVersions());
    }

    private boolean snapshotEquals(@Nullable Snapshot s1, @Nullable Snapshot s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return Objects.equals(s1.getTimestamp(), s2.getTimestamp()) && s1.getBuildNumber() == s2.getBuildNumber() && s1.isLocalCopy() == s2.isLocalCopy();
    }

    private boolean snapshotVersionsEquals(@Nullable List<SnapshotVersion> s1, @Nullable List<SnapshotVersion> s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        if (s1.size() != s2.size()) {
            return false;
        }
        return IntStream.range(0, s1.size()).allMatch(i -> this.snapshotVersionEquals((SnapshotVersion)s1.get(i), (SnapshotVersion)s2.get(i)));
    }

    private boolean snapshotVersionEquals(SnapshotVersion s1, SnapshotVersion s2) {
        return Objects.equals(s1.getClassifier(), s2.getClassifier()) && Objects.equals(s1.getExtension(), s2.getExtension()) && Objects.equals(s1.getVersion(), s2.getVersion()) && Objects.equals(s1.getUpdated(), s2.getUpdated());
    }

    private boolean pluginsEquals(@Nullable List<Plugin> p1, @Nullable List<Plugin> p2) {
        if (p1 == null || p2 == null) {
            return p1 == p2;
        }
        if (p1.size() != p2.size()) {
            return false;
        }
        return IntStream.range(0, p1.size()).allMatch(i -> this.pluginEquals((Plugin)p1.get(i), (Plugin)p2.get(i)));
    }

    private boolean pluginEquals(Plugin p1, Plugin p2) {
        return Objects.equals(p1.getName(), p2.getName()) && Objects.equals(p1.getPrefix(), p2.getPrefix()) && Objects.equals(p1.getArtifactId(), p2.getArtifactId());
    }

    @Nullable
    public Metadata merge(Iterable<Envelope> metadatas) {
        Preconditions.checkNotNull(metadatas);
        Metadata result = null;
        for (Envelope envelope : metadatas) {
            if (result == null) {
                result = envelope.getData().clone();
                continue;
            }
            try {
                result = this.merge(result, envelope.getData().clone());
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Bad data {}", (Object)envelope.getOrigin(), (Object)e);
            }
        }
        if (result == null) {
            return null;
        }
        if (result.getVersioning() != null && !result.getVersioning().getVersions().isEmpty()) {
            Collections.sort(result.getVersioning().getVersions(), VersionComparator.INSTANCE);
            String latest = (String)result.getVersioning().getVersions().get(result.getVersioning().getVersions().size() - 1);
            String release = null;
            int i = result.getVersioning().getVersions().size() - 1;
            while (i >= 0) {
                if (!((String)result.getVersioning().getVersions().get(i)).endsWith("SNAPSHOT")) {
                    release = (String)result.getVersioning().getVersions().get(i);
                    break;
                }
                --i;
            }
            result.getVersioning().setLatest(latest);
            result.getVersioning().setRelease(release);
        }
        if (!result.getPlugins().isEmpty()) {
            Collections.sort(result.getPlugins(), pluginComparator);
        }
        result.setModelVersion(ModelVersion.V1_1_0.getVersionString());
        return result;
    }

    private Metadata merge(Metadata target, Metadata source) {
        if (Strings.isNullOrEmpty((String)source.getGroupId())) {
            source.setGroupId(target.getGroupId());
        }
        if (Strings.isNullOrEmpty((String)source.getArtifactId())) {
            source.setArtifactId(target.getArtifactId());
        }
        if (Strings.isNullOrEmpty((String)target.getVersion())) {
            target.setVersion(source.getVersion());
        }
        if (Strings.isNullOrEmpty((String)source.getVersion())) {
            source.setVersion(target.getVersion());
        }
        Preconditions.checkArgument((boolean)Objects.equals(RepositoryMetadataMerger.nullOrEmptyStringFilter(target.getGroupId()), RepositoryMetadataMerger.nullOrEmptyStringFilter(source.getGroupId())), (String)"GroupId mismatch: %s vs %s", (Object)target.getGroupId(), (Object)source.getGroupId());
        Preconditions.checkArgument((boolean)Objects.equals(RepositoryMetadataMerger.nullOrEmptyStringFilter(target.getArtifactId()), RepositoryMetadataMerger.nullOrEmptyStringFilter(source.getArtifactId())), (String)"ArtifactId mismatch: %s vs %s", (Object)target.getArtifactId(), (Object)source.getArtifactId());
        String targetVersion = RepositoryMetadataMerger.nullOrEmptyStringFilter(target.getVersion());
        String sourceVersion = RepositoryMetadataMerger.nullOrEmptyStringFilter(source.getVersion());
        if (!Objects.equals(targetVersion, sourceVersion)) {
            this.log.warn("Merging with version mismatch for GA={}:{}, {} vs {}", new Object[]{target.getGroupId(), target.getArtifactId(), targetVersion, sourceVersion});
        }
        this.mergePlugins(target, source);
        this.mergeVersioning(target, source);
        return target;
    }

    private void mergePlugins(Metadata left, Metadata right) {
        RepositoryMetadataMerger.nullElementFilter(left.getPlugins());
        RepositoryMetadataMerger.nullElementFilter(right.getPlugins());
        for (Plugin plugin : right.getPlugins()) {
            boolean found = false;
            for (Plugin preExisting : left.getPlugins()) {
                if (!Objects.equals(preExisting.getArtifactId(), plugin.getArtifactId()) || !Objects.equals(preExisting.getPrefix(), plugin.getPrefix())) continue;
                found = true;
                preExisting.setName(plugin.getName());
                break;
            }
            if (found) continue;
            Plugin newPlugin = new Plugin();
            newPlugin.setArtifactId(plugin.getArtifactId());
            newPlugin.setPrefix(plugin.getPrefix());
            newPlugin.setName(plugin.getName());
            left.addPlugin(newPlugin);
        }
    }

    private void mergeVersioning(Metadata left, Metadata right) {
        long rts;
        long lts;
        if (right.getVersioning() == null) {
            return;
        }
        if (left.getVersioning() == null) {
            left.setVersioning(new Versioning());
        }
        Versioning rv = right.getVersioning();
        Versioning lv = left.getVersioning();
        if (rv.getLastUpdated() != null) {
            if (lv.getLastUpdated() == null) {
                lv.setLastUpdated(rv.getLastUpdated());
            } else {
                lts = this.ts(lv.getLastUpdated());
                rts = this.ts(rv.getLastUpdated());
                if (rts > lts) {
                    lv.setLastUpdated(rv.getLastUpdated());
                }
            }
        }
        RepositoryMetadataMerger.nullElementFilter(lv.getVersions());
        RepositoryMetadataMerger.nullElementFilter(rv.getVersions());
        for (String version : rv.getVersions()) {
            if (lv.getVersions().contains(version)) continue;
            lv.getVersions().add(version);
        }
        if (rv.getSnapshot() != null) {
            if (lv.getSnapshot() == null) {
                lv.setSnapshot(rv.getSnapshot());
            } else {
                lts = this.ts(lv.getSnapshot().getTimestamp());
                rts = this.ts(rv.getSnapshot().getTimestamp());
                if (rts > lts) {
                    lv.setSnapshot(rv.getSnapshot());
                }
            }
        }
        RepositoryMetadataMerger.nullElementFilter(lv.getSnapshotVersions());
        RepositoryMetadataMerger.nullElementFilter(rv.getSnapshotVersions());
        for (SnapshotVersion snapshotVersion : rv.getSnapshotVersions()) {
            boolean found = false;
            for (SnapshotVersion preExisting : lv.getSnapshotVersions()) {
                if (!Objects.equals(snapshotVersion.getExtension(), preExisting.getExtension()) || !Objects.equals(RepositoryMetadataMerger.nullOrEmptyStringFilter(snapshotVersion.getClassifier()), RepositoryMetadataMerger.nullOrEmptyStringFilter(preExisting.getClassifier()))) continue;
                found = true;
                if (VersionComparator.version((String)snapshotVersion.getVersion()).compareTo((Object)VersionComparator.version((String)preExisting.getVersion())) <= 0) break;
                preExisting.setClassifier(RepositoryMetadataMerger.nullOrEmptyStringFilter(snapshotVersion.getClassifier()));
                preExisting.setVersion(snapshotVersion.getVersion());
                preExisting.setUpdated(snapshotVersion.getUpdated());
                break;
            }
            if (found) continue;
            SnapshotVersion newSnapshotVersion = new SnapshotVersion();
            newSnapshotVersion.setExtension(snapshotVersion.getExtension());
            newSnapshotVersion.setClassifier(snapshotVersion.getClassifier());
            newSnapshotVersion.setVersion(snapshotVersion.getVersion());
            newSnapshotVersion.setUpdated(snapshotVersion.getUpdated());
            lv.getSnapshotVersions().add(newSnapshotVersion);
        }
    }

    private long ts(String ts) {
        try {
            if (ts != null) {
                return Long.parseLong(ts.replace(".", ""));
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return -1L;
    }

    public static class Envelope {
        private final String origin;
        private final Metadata data;

        public Envelope(String origin, Metadata data) {
            this.origin = (String)Preconditions.checkNotNull((Object)origin);
            this.data = (Metadata)Preconditions.checkNotNull((Object)data);
        }

        @Nonnull
        public String getOrigin() {
            return this.origin;
        }

        @Nonnull
        public Metadata getData() {
            return this.data;
        }
    }

    private static enum ModelVersion {
        V1_0_0("1.0.0"),
        V1_1_0("1.1.0");

        private final String versionString;

        private ModelVersion(String versionString) {
            this.versionString = versionString;
        }

        public String getVersionString() {
            return this.versionString;
        }
    }
}

