/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named
public class HostedHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String action;
        MavenPath path = (MavenPath)context.getAttributes().require(MavenPath.class);
        MavenFacet mavenFacet = (MavenFacet)context.getRepository().facet(MavenFacet.class);
        switch (action = context.getRequest().getAction()) {
            case "GET": 
            case "HEAD": {
                return this.doGet(path, mavenFacet);
            }
            case "PUT": {
                return this.doPut(context, path, mavenFacet);
            }
            case "DELETE": {
                return this.doDelete(path, mavenFacet);
            }
        }
        return HttpResponses.methodNotAllowed((String)context.getRequest().getAction(), (String[])new String[]{"GET", "HEAD", "PUT", "DELETE"});
    }

    private Response doGet(MavenPath path, MavenFacet mavenFacet) throws IOException {
        Content content = mavenFacet.get(path);
        if (content == null) {
            return HttpResponses.notFound((String)path.getPath());
        }
        AttributesMap attributesMap = content.getAttributes();
        MavenFacetUtils.mayAddETag(attributesMap, MavenFacetUtils.getHashAlgorithmFromContent(attributesMap));
        return HttpResponses.ok((Payload)content);
    }

    private Response doPut(@Nonnull Context context, MavenPath path, MavenFacet mavenFacet) throws IOException {
        if (mavenFacet.layoutPolicy() == LayoutPolicy.STRICT && this.isValidSnapshot(path.getCoordinates()) && !mavenFacet.getMavenPathParser().isRepositoryMetadata(path)) {
            throw new IllegalOperationException("Invalid path for a Maven 2 repository");
        }
        mavenFacet.put(path, context.getRequest().getPayload());
        return HttpResponses.created();
    }

    private Response doDelete(MavenPath path, MavenFacet mavenFacet) throws IOException {
        boolean deleted = mavenFacet.delete(path);
        if (!deleted) {
            return HttpResponses.notFound((String)path.getPath());
        }
        return HttpResponses.noContent();
    }

    private boolean isValidSnapshot(MavenPath.Coordinates coordinates) {
        return coordinates == null || coordinates.isSnapshot() && !coordinates.getVersion().equals(coordinates.getBaseVersion()) && (coordinates.getTimestamp() == null || coordinates.getBuildNumber() == null);
    }
}

