/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.maven.MavenHostedFacet;
import org.sonatype.nexus.repository.maven.internal.MavenComponentMaintenanceFacet;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenHostedComponentMaintenanceFacet
extends MavenComponentMaintenanceFacet {
    public Set<String> deleteComponent(EntityId componentId, boolean deleteBlobs) {
        String[] coordinates = (String[])Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> this.findComponent(componentId));
        Set deletedAssets = super.deleteComponent(componentId, deleteBlobs);
        if (coordinates != null) {
            MavenHostedFacet facet = (MavenHostedFacet)this.getRepository().facet(MavenHostedFacet.class);
            Set<String> deletedMetadataPaths = facet.deleteMetadata(coordinates[0], coordinates[1], coordinates[2]);
            deletedAssets.addAll(deletedMetadataPaths);
        }
        return deletedAssets;
    }

    protected long doBatchDelete(List<EntityId> entityIds, BooleanSupplier cancelledCheck) {
        long count = 0L;
        try {
            List<String[]> gavs = this.collectGavs(entityIds);
            count += this.deleteComponentBatch(entityIds, cancelledCheck);
            ((MavenHostedFacet)this.getRepository().facet(MavenHostedFacet.class)).deleteMetadata(gavs);
        }
        catch (Exception ex) {
            this.log.debug("Error encountered attempting to delete components for repository {}.", (Object)this.getRepository().getName(), (Object)ex);
        }
        return count;
    }

    @Transactional
    protected List<String[]> collectGavs(List<EntityId> entityIds) {
        return entityIds.stream().map(this::findComponent).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private String[] findComponent(EntityId entityId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(entityId, tx.findBucket(this.getRepository()));
        if (component != null) {
            return new String[]{(String)component.formatAttributes().get("groupId", String.class), (String)component.formatAttributes().get("artifactId", String.class), (String)component.formatAttributes().get("baseVersion", String.class)};
        }
        return null;
    }

    public void after() {
        ((MavenHostedFacet)this.getRepository().facet(MavenHostedFacet.class)).rebuildMetadata(null, null, null, true);
    }
}

