/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.index.reader.Record;
import org.sonatype.nexus.repository.maven.internal.MavenIndexFacetSupport;
import org.sonatype.nexus.repository.maven.internal.MavenIndexPublisher;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategy;
import org.sonatype.nexus.repository.maven.internal.filter.DuplicateDetectionStrategyProvider;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenHostedIndexFacet
extends MavenIndexFacetSupport {
    private final DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider;

    @Inject
    public MavenHostedIndexFacet(DuplicateDetectionStrategyProvider duplicateDetectionStrategyProvider) {
        this.duplicateDetectionStrategyProvider = (DuplicateDetectionStrategyProvider)((Object)Preconditions.checkNotNull((Object)((Object)duplicateDetectionStrategyProvider)));
    }

    @Override
    public void publishIndex() throws IOException {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Object strategy = this.duplicateDetectionStrategyProvider.get();){
                MavenIndexPublisher.publishHostedIndex(this.getRepository(), (DuplicateDetectionStrategy<Record>)strategy);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            UnitOfWork.end();
        }
    }
}

