/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.entity.AttachedEntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.MavenPathParser;
import org.sonatype.nexus.repository.maven.internal.DigestExtractor;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataBuilder;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUpdater;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Singleton
@Named
public class MetadataRebuilder
extends ComponentSupport {
    private final int bufferSize;
    private final int timeoutSeconds;

    @Inject
    public MetadataRebuilder(@Named(value="${nexus.maven.metadata.rebuild.bufferSize:-1000}") int bufferSize, @Named(value="${nexus.maven.metadata.rebuild.timeoutSeconds:-60}") int timeoutSeconds) {
        this.bufferSize = bufferSize;
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean rebuild(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
        UnitOfWork.beginBatch((Transaction)tx);
        try {
            boolean bl = new Worker(repository, update, rebuildChecksums, groupId, artifactId, baseVersion, this.bufferSize, this.timeoutSeconds).rebuildMetadata();
            return bl;
        }
        finally {
            UnitOfWork.end();
        }
    }

    public void deleteMetadata(Repository repository, List<String[]> gavs) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull(gavs);
        ArrayList<MavenPath> pathBatch = new ArrayList<MavenPath>();
        for (String[] gav : gavs) {
            pathBatch.addAll(this.getPathsByGav(repository, gav[0], gav[1], gav[2]));
        }
        try {
            MavenFacetUtils.deleteWithHashes((MavenFacet)repository.facet(MavenFacet.class), pathBatch);
        }
        catch (IOException e) {
            this.log.warn("Error encountered when deleting metadata: repository={}", (Object)repository);
            throw new RuntimeException(e);
        }
    }

    private List<MavenPath> getPathsByGav(Repository repository, String groupId, String artifactId, String baseVersion) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)baseVersion);
        this.log.debug("Collecting MavenPaths for Maven2 hosted repository metadata: repository={}, g={}, a={}, bV={}", new Object[]{repository.getName(), groupId, artifactId, baseVersion});
        ArrayList<MavenPath> paths = new ArrayList<MavenPath>();
        try {
            paths.add(MetadataUtils.metadataPath(groupId, artifactId, baseVersion));
            paths.add(MetadataUtils.metadataPath(groupId, artifactId, null));
            MavenPath groupPath = MetadataUtils.metadataPath(groupId, null, null);
            if (MetadataUtils.read(repository, groupPath) != null) {
                paths.add(groupPath);
            }
            return paths;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> deleteAndRebuild(Repository repository, String groupId, String artifactId, String baseVersion) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)artifactId);
        Preconditions.checkNotNull((Object)baseVersion);
        HashSet<String> deletedPaths = new HashSet<String>();
        StorageTx tx = (StorageTx)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier().get();
        UnitOfWork.beginBatch((Transaction)tx);
        boolean groupChange = false;
        try {
            try {
                MavenPath gavMetadataPath = MetadataUtils.metadataPath(groupId, artifactId, baseVersion);
                MetadataUtils.delete(repository, gavMetadataPath);
                deletedPaths.addAll(MavenFacetUtils.getPathWithHashes(gavMetadataPath));
                MavenPath gaMetadataPath = MetadataUtils.metadataPath(groupId, artifactId, null);
                MetadataUtils.delete(repository, gaMetadataPath);
                deletedPaths.addAll(MavenFacetUtils.getPathWithHashes(gaMetadataPath));
                MavenPath groupPath = MetadataUtils.metadataPath(groupId, null, null);
                if (MetadataUtils.read(repository, groupPath) != null) {
                    MetadataUtils.delete(repository, groupPath);
                    deletedPaths.addAll(MavenFacetUtils.getPathWithHashes(groupPath));
                    groupChange = true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            UnitOfWork.end();
        }
        boolean rebuild = groupChange ? this.rebuild(repository, true, false, groupId, null, null) : this.rebuild(repository, true, false, groupId, artifactId, null);
        if (rebuild) {
            return Collections.emptySet();
        }
        return deletedPaths;
    }

    private static class Worker
    extends ComponentSupport {
        private final Repository repository;
        private final MavenFacet mavenFacet;
        private final MavenPathParser mavenPathParser;
        private final MetadataBuilder metadataBuilder;
        private final MetadataUpdater metadataUpdater;
        private final Map<String, Object> sqlParams;
        private final String sql;
        private final boolean rebuildChecksums;
        private final int bufferSize;
        private final long timeoutSeconds;

        public Worker(Repository repository, boolean update, boolean rebuildChecksums, @Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion, int bufferSize, int timeoutSeconds) {
            this.repository = repository;
            this.mavenFacet = (MavenFacet)repository.facet(MavenFacet.class);
            this.mavenPathParser = this.mavenFacet.getMavenPathParser();
            this.metadataBuilder = new MetadataBuilder();
            this.metadataUpdater = new MetadataUpdater(update, repository);
            this.sqlParams = Maps.newHashMap();
            this.sql = this.buildSql(groupId, artifactId, baseVersion);
            this.rebuildChecksums = rebuildChecksums;
            this.bufferSize = bufferSize;
            this.timeoutSeconds = timeoutSeconds;
        }

        private String buildSql(@Nullable String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
            this.sqlParams.put("bucket", this.findBucketORID(this.repository));
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("SELECT %s as groupId, %s as artifactId, set(%s.%s.%s) as baseVersions FROM %s WHERE %s=:bucket", "group", "name", "attributes", "maven2", "baseVersion", "component", "bucket"));
            if (!Strings.isNullOrEmpty((String)groupId)) {
                builder.append(" AND group=:groupId");
                this.sqlParams.put("groupId", groupId);
                if (!Strings.isNullOrEmpty((String)artifactId)) {
                    builder.append(" AND name=:artifactId");
                    this.sqlParams.put("artifactId", artifactId);
                    if (!Strings.isNullOrEmpty((String)baseVersion)) {
                        builder.append(" AND attributes.maven2.baseVersion=:baseVersion");
                        this.sqlParams.put("baseVersion", baseVersion);
                    }
                }
            }
            builder.append(" GROUP BY group, name");
            return builder.toString();
        }

        private ORID findBucketORID(Repository repository) {
            return (ORID)Transactional.operation.call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                return AttachedEntityHelper.id((Entity)tx.findBucket(repository));
            });
        }

        private Iterable<ODocument> browseGAVs() {
            return (Iterable)Transactional.operation.call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                return tx.browse(this.sql, this.sqlParams, this.bufferSize, this.timeoutSeconds);
            });
        }

        public boolean rebuildMetadata() {
            boolean metadataRebuilt = false;
            CancelableHelper.checkCancellation();
            String currentGroupId = null;
            for (ODocument doc : this.browseGAVs()) {
                boolean groupChange;
                CancelableHelper.checkCancellation();
                String groupId = (String)doc.field("groupId", OType.STRING);
                String artifactId = (String)doc.field("artifactId", OType.STRING);
                Set baseVersions = (Set)doc.field("baseVersions", OType.EMBEDDEDSET);
                boolean bl = groupChange = !Objects.equals(currentGroupId, groupId);
                if (groupChange) {
                    if (currentGroupId != null) {
                        this.rebuildMetadataExitGroup(currentGroupId);
                    }
                    currentGroupId = groupId;
                    this.metadataBuilder.onEnterGroupId(groupId);
                }
                this.rebuildMetadataInner(groupId, artifactId, baseVersions);
                metadataRebuilt = true;
            }
            if (currentGroupId != null) {
                this.rebuildMetadataExitGroup(currentGroupId);
                metadataRebuilt = true;
            }
            return metadataRebuilt;
        }

        private void rebuildMetadataExitGroup(String currentGroupId) {
            this.metadataUpdater.processMetadata(MetadataUtils.metadataPath(currentGroupId, null, null), this.metadataBuilder.onExitGroupId());
        }

        private void rebuildMetadataInner(String groupId, String artifactId, Set<String> baseVersions) {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            this.metadataBuilder.onEnterArtifactId(artifactId);
            for (String baseVersion : baseVersions) {
                CancelableHelper.checkCancellation();
                this.metadataBuilder.onEnterBaseVersion(baseVersion);
                TransactionalStoreBlob.operation.call(() -> {
                    Bucket bucket = tx.findBucket(this.repository);
                    Query query = Query.builder().where("group").eq((Object)groupId).and("name").eq((Object)artifactId).build();
                    Iterable filteredComponents = Iterables.filter((Iterable)tx.browseComponents(query, bucket), component -> {
                        String thisVersion = (String)component.formatAttributes().get("baseVersion");
                        return baseVersion.equals(thisVersion);
                    });
                    for (Component component2 : filteredComponents) {
                        CancelableHelper.checkCancellation();
                        for (Asset asset : tx.browseAssets(component2)) {
                            CancelableHelper.checkCancellation();
                            MavenPath mavenPath = this.mavenPathParser.parsePath(asset.name());
                            if (mavenPath.isSubordinate()) continue;
                            this.metadataBuilder.addArtifactVersion(mavenPath);
                            if (this.rebuildChecksums) {
                                this.mayUpdateChecksum(asset, mavenPath, MavenPath.HashType.SHA1);
                                this.mayUpdateChecksum(asset, mavenPath, MavenPath.HashType.MD5);
                            }
                            String packaging = (String)component2.formatAttributes().get("packaging", String.class);
                            this.log.debug("POM packaging: {}", (Object)packaging);
                            if (!"maven-plugin".equals(packaging)) continue;
                            this.metadataBuilder.addPlugin(this.getPluginPrefix(mavenPath.locateMainArtifact("jar")), artifactId, (String)component2.formatAttributes().get("pom_name", String.class));
                        }
                    }
                    this.metadataUpdater.processMetadata(MetadataUtils.metadataPath(groupId, artifactId, baseVersion), this.metadataBuilder.onExitBaseVersion());
                    return null;
                });
            }
            this.metadataUpdater.processMetadata(MetadataUtils.metadataPath(groupId, artifactId, null), this.metadataBuilder.onExitArtifactId());
        }

        private void mayUpdateChecksum(Asset asset, MavenPath mavenPath, MavenPath.HashType hashType) {
            MavenPath checksumPath;
            String assetChecksum;
            block15: {
                HashCode checksum = asset.getChecksum(hashType.getHashAlgorithm());
                if (checksum == null) {
                    this.log.warn("Asset with path {} lacks checksum {}", (Object)mavenPath, (Object)hashType);
                    return;
                }
                assetChecksum = checksum.toString();
                checksumPath = mavenPath.hash(hashType);
                try {
                    Content content = this.mavenFacet.get(checksumPath);
                    if (content == null) break block15;
                    Throwable throwable = null;
                    Object var9_12 = null;
                    try (InputStream is = content.openInputStream();){
                        String mavenChecksum = DigestExtractor.extract(is);
                        if (!Objects.equals(assetChecksum, mavenChecksum)) break block15;
                        return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log.warn("Error reading {}", (Object)checksumPath, (Object)e);
                }
            }
            try {
                this.log.debug("Generating checksum file: {}", (Object)checksumPath);
                StringPayload mavenChecksum = new StringPayload(assetChecksum, "text/plain");
                this.mavenFacet.put(checksumPath, (Payload)mavenChecksum);
            }
            catch (IOException e) {
                this.log.warn("Error writing {}", (Object)checksumPath, (Object)e);
                throw new RuntimeException(e);
            }
        }

        private Xpp3Dom parse(MavenPath mavenPath, InputStream is) {
            try {
                Xpp3Dom dom = MavenModels.parseDom(is);
                if (dom == null) {
                    this.log.debug("Could not parse POM: {} @ {}", (Object)this.repository.getName(), (Object)mavenPath.getPath());
                }
                return dom;
            }
            catch (IOException e) {
                this.log.warn("Could not parse POM: {} @ {}", new Object[]{this.repository.getName(), mavenPath.getPath(), e});
                throw new RuntimeException(e);
            }
        }

        private String getPluginPrefix(MavenPath mavenPath) {
            String prefix;
            block15: {
                Preconditions.checkArgument((mavenPath.getCoordinates() != null ? 1 : 0) != 0);
                Preconditions.checkArgument((boolean)Objects.equals(mavenPath.getCoordinates().getExtension(), "jar"));
                prefix = null;
                try {
                    Content jarFile = this.mavenFacet.get(mavenPath);
                    if (jarFile == null) break block15;
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (ZipInputStream zip = new ZipInputStream(jarFile.openInputStream());){
                        ZipEntry entry;
                        while ((entry = zip.getNextEntry()) != null) {
                            if (!entry.isDirectory() && "META-INF/maven/plugin.xml".equals(entry.getName())) {
                                Xpp3Dom dom = this.parse(mavenPath, zip);
                                prefix = this.getChildValue(dom, "goalPrefix", null);
                                break;
                            }
                            zip.closeEntry();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.log.warn("Unable to read plugin.xml of {}", (Object)mavenPath, (Object)e);
                }
            }
            if (prefix != null) {
                return prefix;
            }
            if ("maven-plugin-plugin".equals(mavenPath.getCoordinates().getArtifactId())) {
                return "plugin";
            }
            return mavenPath.getCoordinates().getArtifactId().replaceAll("-?maven-?", "").replaceAll("-?plugin-?", "");
        }

        private String getChildValue(Xpp3Dom doc, String childName, String defaultValue) {
            Xpp3Dom child = doc.getChild(childName);
            if (child == null) {
                return defaultValue;
            }
            return child.getValue();
        }
    }
}

