/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Plugin;
import org.apache.maven.artifact.repository.metadata.Snapshot;
import org.apache.maven.artifact.repository.metadata.SnapshotVersion;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.Constants;
import org.sonatype.nexus.repository.maven.internal.group.RepositoryMetadataMerger;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.Maven2Metadata;
import org.sonatype.nexus.repository.maven.internal.hosted.metadata.MetadataUtils;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;

public class MetadataUpdater
extends ComponentSupport {
    private final boolean update;
    private final Repository repository;
    private final RepositoryMetadataMerger repositoryMetadataMerger;

    public MetadataUpdater(boolean update, Repository repository) {
        this.update = update;
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.repositoryMetadataMerger = new RepositoryMetadataMerger();
    }

    public void processMetadata(MavenPath metadataPath, Maven2Metadata metadata) {
        if (metadata != null) {
            if (this.update) {
                this.update(metadataPath, metadata);
            } else {
                this.replace(metadataPath, metadata);
            }
        } else if (!this.update) {
            this.delete(metadataPath);
        }
    }

    @VisibleForTesting
    void update(MavenPath mavenPath, Maven2Metadata metadata) {
        try {
            TransactionalStoreBlob.operation.throwing(IOException.class).call(() -> {
                Preconditions.checkNotNull((Object)mavenPath);
                Preconditions.checkNotNull((Object)metadata);
                Metadata oldMetadata = MetadataUtils.read(this.repository, mavenPath);
                if (oldMetadata == null) {
                    this.write(mavenPath, this.toMetadata(metadata));
                } else {
                    Metadata updated = this.repositoryMetadataMerger.merge((Iterable<RepositoryMetadataMerger.Envelope>)ImmutableList.of((Object)new RepositoryMetadataMerger.Envelope(String.valueOf(this.repository.getName()) + ":" + mavenPath.getPath(), oldMetadata), (Object)new RepositoryMetadataMerger.Envelope("new:" + mavenPath.getPath(), this.toMetadata(metadata))));
                    this.writeIfUnchanged(mavenPath, oldMetadata, updated);
                }
                return null;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    void replace(MavenPath mavenPath, Maven2Metadata metadata) {
        try {
            TransactionalStoreBlob.operation.throwing(IOException.class).call(() -> {
                Preconditions.checkNotNull((Object)mavenPath);
                Preconditions.checkNotNull((Object)metadata);
                Metadata oldMetadata = MetadataUtils.read(this.repository, mavenPath);
                if (oldMetadata == null) {
                    this.write(mavenPath, this.toMetadata(metadata));
                } else {
                    Metadata updated = this.toMetadata(metadata);
                    this.writeIfUnchanged(mavenPath, oldMetadata, updated);
                }
                return null;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    void delete(MavenPath mavenPath) {
        MetadataUtils.delete(this.repository, mavenPath);
    }

    private Metadata toMetadata(Maven2Metadata maven2Metadata) {
        Versioning versioning;
        Metadata result = new Metadata();
        result.setModelVersion("1.1.0");
        result.setGroupId(maven2Metadata.getGroupId());
        result.setArtifactId(maven2Metadata.getArtifactId());
        result.setVersion(maven2Metadata.getVersion());
        if (maven2Metadata.getPlugins() != null) {
            for (Maven2Metadata.Plugin plugin : maven2Metadata.getPlugins()) {
                Plugin mPlugin = new Plugin();
                mPlugin.setArtifactId(plugin.getArtifactId());
                mPlugin.setPrefix(plugin.getPrefix());
                mPlugin.setName(plugin.getName());
                result.addPlugin(mPlugin);
            }
        }
        if (maven2Metadata.getBaseVersions() != null) {
            versioning = new Versioning();
            versioning.setLatest(maven2Metadata.getBaseVersions().getLatest());
            versioning.setRelease(maven2Metadata.getBaseVersions().getRelease());
            versioning.setVersions(maven2Metadata.getBaseVersions().getVersions());
            versioning.setLastUpdated(Constants.METADATA_DOTLESS_TIMESTAMP.print((ReadableInstant)maven2Metadata.getLastUpdated()));
            result.setVersioning(versioning);
        }
        if (maven2Metadata.getSnapshots() != null) {
            versioning = result.getVersioning() != null ? result.getVersioning() : new Versioning();
            Snapshot snapshot = new Snapshot();
            snapshot.setTimestamp(Constants.METADATA_DOTTED_TIMESTAMP.print((ReadableInstant)new DateTime(maven2Metadata.getSnapshots().getSnapshotTimestamp())));
            snapshot.setBuildNumber(maven2Metadata.getSnapshots().getSnapshotBuildNumber());
            versioning.setSnapshot(snapshot);
            ArrayList snapshotVersions = Lists.newArrayList();
            for (Maven2Metadata.Snapshot snap : maven2Metadata.getSnapshots().getSnapshots()) {
                SnapshotVersion snapshotVersion = new SnapshotVersion();
                snapshotVersion.setExtension(snap.getExtension());
                snapshotVersion.setClassifier(snap.getClassifier());
                snapshotVersion.setVersion(snap.getVersion());
                snapshotVersion.setUpdated(Constants.METADATA_DOTLESS_TIMESTAMP.print((ReadableInstant)snap.getLastUpdated()));
                snapshotVersions.add(snapshotVersion);
            }
            versioning.setSnapshotVersions((List)snapshotVersions);
            versioning.setLastUpdated(Constants.METADATA_DOTLESS_TIMESTAMP.print((ReadableInstant)maven2Metadata.getLastUpdated()));
            result.setVersioning(versioning);
        }
        return result;
    }

    @Nullable
    public Metadata read(MavenPath mavenPath) throws IOException {
        return MetadataUtils.read(this.repository, mavenPath);
    }

    public void write(MavenPath mavenPath, Metadata metadata) throws IOException {
        MetadataUtils.write(this.repository, mavenPath, metadata);
    }

    private void writeIfUnchanged(MavenPath mavenPath, Metadata oldMetadata, Metadata newMetadata) throws IOException {
        if (this.repositoryMetadataMerger.metadataEquals(oldMetadata, newMetadata)) {
            this.log.info("metadata for {} hasn't changed, skipping", (Object)mavenPath);
        } else {
            this.write(mavenPath, newMetadata);
        }
    }
}

