/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.hosted.metadata;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.maven.internal.MavenModels;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public final class MetadataUtils {
    private static Logger log = LoggerFactory.getLogger(MetadataUtils.class);

    private MetadataUtils() {
    }

    public static MavenPath metadataPath(String groupId, @Nullable String artifactId, @Nullable String baseVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append(groupId.replace('.', '/'));
        if (artifactId != null) {
            sb.append("/").append(artifactId);
            if (baseVersion != null) {
                sb.append("/").append(baseVersion);
            }
        }
        sb.append("/").append("maven-metadata.xml");
        return new MavenPath(sb.toString(), null);
    }

    @Nullable
    public static Metadata read(Repository repository, MavenPath mavenPath) throws IOException {
        Content content = ((MavenFacet)repository.facet(MavenFacet.class)).get(mavenPath);
        if (content == null) {
            return null;
        }
        Metadata metadata = MavenModels.readMetadata(content.openInputStream());
        if (metadata == null) {
            log.warn("Corrupted metadata {} @ {}", (Object)repository.getName(), (Object)mavenPath.getPath());
        }
        return metadata;
    }

    public static void write(Repository repository, MavenPath mavenPath, Metadata metadata) throws IOException {
        MavenFacet mavenFacet = (MavenFacet)repository.facet(MavenFacet.class);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MavenModels.writeMetadata(buffer, metadata);
        mavenFacet.put(mavenPath, (Payload)new BytesPayload(buffer.toByteArray(), "application/xml"));
        Map hashCodes = (Map)mavenFacet.get(mavenPath).getAttributes().require("hashCodesMap", Content.T_CONTENT_HASH_CODES_MAP);
        Preconditions.checkState((hashCodes != null ? 1 : 0) != 0, (Object)"hashCodes");
        MavenPath.HashType[] hashTypeArray = MavenPath.HashType.values();
        int n = hashTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MavenPath.HashType hashType = hashTypeArray[n2];
            MavenPath checksumPath = mavenPath.hash(hashType);
            HashCode hashCode = (HashCode)hashCodes.get(hashType.getHashAlgorithm());
            Preconditions.checkState((hashCode != null ? 1 : 0) != 0, (String)"hashCode: type=%s", (Object)((Object)hashType));
            mavenFacet.put(checksumPath, (Payload)new StringPayload(hashCode.toString(), "text/plain"));
            ++n2;
        }
    }

    public static void delete(Repository repository, MavenPath mavenPath) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)mavenPath);
        try {
            MavenFacetUtils.deleteWithHashes((MavenFacet)repository.facet(MavenFacet.class), mavenPath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

