/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.proxy;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.maven.LayoutPolicy;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.maven.internal.MavenFacetUtils;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class MavenProxyFacet
extends ProxyFacetSupport {
    private MavenFacet mavenFacet;

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.mavenFacet = (MavenFacet)this.facet(MavenFacet.class);
    }

    protected Content getCachedContent(Context context) throws IOException {
        return this.mavenFacet.get(this.mavenPath(context));
    }

    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        MavenPath mavenPath;
        if (!(stale != null || this.mavenFacet.layoutPolicy() != LayoutPolicy.STRICT || (mavenPath = this.mavenPath(context)).getCoordinates() != null || this.mavenFacet.getMavenPathParser().isRepositoryMetadata(mavenPath) || this.mavenFacet.getMavenPathParser().isRepositoryIndex(mavenPath) || mavenPath.getFileName().equals("archetype-catalog.xml"))) {
            return null;
        }
        return super.fetch(context, stale);
    }

    protected CacheController getCacheController(@Nonnull Context context) {
        if (this.mavenFacet.getMavenPathParser().isRepositoryMetadata(this.mavenPath(context))) {
            return this.cacheControllerHolder.getMetadataCacheController();
        }
        return this.cacheControllerHolder.getContentCacheController();
    }

    protected Content store(Context context, Content payload) throws IOException {
        return this.mavenFacet.put(this.mavenPath(context), (Payload)payload);
    }

    @TransactionalTouchMetadata
    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        MavenPath path = this.mavenPath(context);
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)bucket, (Content)content);
        if (asset == null) {
            asset = MavenFacetUtils.findAsset(tx, bucket, path);
        }
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent maven asset {}", (Object)path.getPath());
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)path.getPath(), (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    protected String getUrl(@Nonnull Context context) {
        return context.getRequest().getPath().substring(1);
    }

    @Nonnull
    private MavenPath mavenPath(@Nonnull Context context) {
        return (MavenPath)context.getAttributes().require(MavenPath.class);
    }
}

