/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.internal.search;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.search.SearchHit;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.search.SearchResultComponent;
import org.sonatype.nexus.repository.search.SearchResultComponentGeneratorSupport;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapterManager;

@Singleton
@Named(value="maven2")
public class Maven2SearchResultComponentGenerator
extends SearchResultComponentGeneratorSupport {
    @Inject
    public Maven2SearchResultComponentGenerator(VariableResolverAdapterManager variableResolverAdapterManager, RepositoryManager repositoryManager, ContentPermissionChecker contentPermissionChecker) {
        super(variableResolverAdapterManager, repositoryManager, contentPermissionChecker);
    }

    public SearchResultComponent from(SearchHit hit, Set<String> componentIdSet) {
        String baseVersionId;
        SearchResultComponent component = null;
        Map source = hit.getSource();
        String repositoryName = this.getPrivilegedRepositoryName(source);
        String group = (String)source.get("group");
        String name = (String)source.get("name");
        String format = (String)source.get("format");
        Optional<String> baseVersion = Optional.ofNullable(source.get("attributes")).map(attributes -> ((Map)attributes).get("maven2")).map(maven2 -> ((Map)maven2).get("baseVersion")).map(Object::toString);
        String baseVersionString = baseVersion.orElse("");
        String string = baseVersionId = baseVersionString.isEmpty() ? "" : String.valueOf(repositoryName) + ":" + group + ":" + name + ":" + baseVersionString;
        if (baseVersionId.isEmpty() || !componentIdSet.contains(baseVersionId)) {
            boolean isSnapshot = Maven2SearchResultComponentGenerator.isSnapshotId(baseVersionId);
            component = new SearchResultComponent();
            component.setId(isSnapshot ? baseVersionId : hit.getId());
            component.setRepositoryName(repositoryName);
            component.setGroup(group);
            component.setName(name);
            component.setFormat(format);
            if (baseVersionString.isEmpty()) {
                component.setVersion((String)source.get("version"));
            } else {
                component.setVersion(baseVersionString);
            }
        }
        return component;
    }

    public static boolean isSnapshotId(String id) {
        return Objects.nonNull(id) && id.endsWith("-SNAPSHOT");
    }
}

