/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.maven.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.maven.PurgeUnusedSnapshotsFacet;
import org.sonatype.nexus.scheduling.Cancelable;

@Named
public class PurgeMavenUnusedSnapshotsTask
extends RepositoryTaskSupport
implements Cancelable {
    public static final String LAST_USED_FIELD_ID = "lastUsed";
    private final Type groupType;
    private final Type hostedType;
    private final Format maven2Format;

    @Inject
    public PurgeMavenUnusedSnapshotsTask(@Named(value="group") Type groupType, @Named(value="hosted") Type hostedType, @Named(value="maven2") Format maven2Format) {
        this.groupType = (Type)Preconditions.checkNotNull((Object)groupType);
        this.hostedType = (Type)Preconditions.checkNotNull((Object)hostedType);
        this.maven2Format = (Format)Preconditions.checkNotNull((Object)maven2Format);
    }

    protected void execute(Repository repository) {
        ((PurgeUnusedSnapshotsFacet)repository.facet(PurgeUnusedSnapshotsFacet.class)).purgeUnusedSnapshots(this.getConfiguration().getInteger(LAST_USED_FIELD_ID, -1));
    }

    protected boolean appliesTo(Repository repository) {
        return this.maven2Format.equals((Object)repository.getFormat()) && (this.hostedType.equals((Object)repository.getType()) || this.groupType.equals((Object)repository.getType()));
    }

    public String getMessage() {
        return "Purge unused Maven snapshot versions from " + this.getRepositoryField();
    }
}

