/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.template.TemplateAccessible;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.rapture.UiPluginDescriptor;
import org.sonatype.nexus.rapture.internal.state.StateComponent;
import org.sonatype.nexus.servlet.ServletHelper;
import org.sonatype.nexus.webresources.GeneratedWebResource;
import org.sonatype.nexus.webresources.WebResource;
import org.sonatype.nexus.webresources.WebResourceBundle;

@Named
@Singleton
public class RaptureWebResourceBundle
extends ComponentSupport
implements WebResourceBundle {
    private final ApplicationVersion applicationVersion;
    private final Provider<HttpServletRequest> servletRequestProvider;
    private final Provider<StateComponent> stateComponentProvider;
    private final TemplateHelper templateHelper;
    private final List<UiPluginDescriptor> pluginDescriptors;
    private final Gson gson;

    @Inject
    public RaptureWebResourceBundle(ApplicationVersion applicationVersion, Provider<HttpServletRequest> servletRequestProvider, Provider<StateComponent> stateComponentProvider, TemplateHelper templateHelper, List<UiPluginDescriptor> pluginDescriptors) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
        this.servletRequestProvider = (Provider)Preconditions.checkNotNull(servletRequestProvider);
        this.stateComponentProvider = (Provider)Preconditions.checkNotNull(stateComponentProvider);
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
        this.pluginDescriptors = (List)Preconditions.checkNotNull(pluginDescriptors);
        this.log.info("UI plugin descriptors:");
        for (UiPluginDescriptor descriptor : pluginDescriptors) {
            this.log.info("  {}", (Object)descriptor.getPluginId());
        }
        this.gson = new GsonBuilder().setPrettyPrinting().create();
    }

    public List<WebResource> getResources() {
        return ImmutableList.of((Object)this.index_html(), (Object)this.bootstrap_js(), (Object)this.app_js());
    }

    private WebResource index_html() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/index.html";
            }

            public String getContentType() {
                return "text/html";
            }

            protected byte[] generate() throws IOException {
                return this.render("index.vm", new TemplateParameters().set("baseUrl", (Object)BaseUrlHolder.get()).set("debug", (Object)this.isDebug()).set("urlSuffix", (Object)this.generateUrlSuffix()).set("styles", (Object)this.getStyles()).set("scripts", (Object)this.getScripts()).set("util", (Object)new TemplateUtil()));
            }
        };
    }

    private WebResource bootstrap_js() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/static/rapture/bootstrap.js";
            }

            public String getContentType() {
                return "application/x-javascript";
            }

            protected byte[] generate() throws IOException {
                return this.render("bootstrap.vm", new TemplateParameters().set("baseUrl", (Object)BaseUrlHolder.get()).set("debug", (Object)this.isDebug()).set("urlSuffix", (Object)this.generateUrlSuffix()).set("namespaces", (Object)this.getNamespaces()));
            }
        };
    }

    private WebResource app_js() {
        return new TemplateWebResource(this){

            public String getPath() {
                return "/static/rapture/app.js";
            }

            public String getContentType() {
                return "application/x-javascript";
            }

            protected byte[] generate() throws IOException {
                return this.render("app.vm", new TemplateParameters().set("baseUrl", (Object)BaseUrlHolder.get()).set("debug", (Object)this.isDebug()).set("state", (Object)gson.toJson((Object)this.getState())).set("pluginConfigs", (Object)this.getPluginConfigs()));
            }
        };
    }

    private String generateUrlSuffix() {
        StringBuilder buff = new StringBuilder();
        String version = this.applicationVersion.getVersion();
        buff.append("_v=").append(version);
        if (version.endsWith("SNAPSHOT")) {
            buff.append("&_dc=").append(System.currentTimeMillis());
        }
        if (this.isDebug()) {
            buff.append("&debug=true");
        }
        return buff.toString();
    }

    private boolean isDebug() {
        HttpServletRequest request = (HttpServletRequest)this.servletRequestProvider.get();
        return ServletHelper.isDebug((HttpServletRequest)request);
    }

    private Map<String, Object> getState() {
        return ((StateComponent)((Object)this.stateComponentProvider.get())).getState(Maps.newHashMap());
    }

    private List<String> getPluginConfigs() {
        ArrayList classNames = Lists.newArrayList();
        for (UiPluginDescriptor descriptor : this.pluginDescriptors) {
            String className = descriptor.getConfigClassName();
            if (className == null) continue;
            classNames.add(className);
        }
        return classNames;
    }

    private List<String> getNamespaces() {
        ArrayList namespaces = Lists.newArrayList();
        for (UiPluginDescriptor descriptor : this.pluginDescriptors) {
            String ns = descriptor.getNamespace();
            if (ns == null) continue;
            namespaces.add(ns);
        }
        return namespaces;
    }

    private String mode(String path) {
        String mode = this.isDebug() ? "debug" : "prod";
        return path.replaceAll("\\{mode\\}", mode);
    }

    private URI uri(String path) {
        try {
            return new URI(String.format("%s/static/rapture/%s", BaseUrlHolder.get(), path));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private List<URI> getStyles() {
        ArrayList styles = Lists.newArrayList();
        styles.add(this.uri(this.mode("resources/loading-{mode}.css")));
        styles.add(this.uri(this.mode("resources/baseapp-{mode}.css")));
        for (UiPluginDescriptor descriptor : this.pluginDescriptors) {
            if (!descriptor.hasStyle()) continue;
            String path = String.format("resources/%s-{mode}.css", descriptor.getPluginId());
            styles.add(this.uri(this.mode(path)));
        }
        return styles;
    }

    private List<URI> getScripts() {
        ArrayList scripts = Lists.newArrayList();
        scripts.add(this.uri(this.mode("baseapp-{mode}.js")));
        scripts.add(this.uri(this.mode("extdirect-{mode}.js")));
        scripts.add(this.uri("bootstrap.js"));
        scripts.add(this.uri("d3.v4.min.js"));
        if (!this.isDebug()) {
            for (UiPluginDescriptor descriptor : this.pluginDescriptors) {
                if (!descriptor.hasScript()) continue;
                String path = String.format("%s-prod.js", descriptor.getPluginId());
                scripts.add(this.uri(path));
            }
        }
        scripts.add(this.uri("app.js"));
        return scripts;
    }

    @TemplateAccessible
    public static class TemplateUtil {
        public String fileName(URI uri) {
            String path = uri.getPath();
            int i = path.lastIndexOf(47);
            return path.substring(i + 1, path.length());
        }
    }

    private abstract class TemplateWebResource
    extends GeneratedWebResource {
        private TemplateWebResource() {
        }

        protected byte[] render(String template, TemplateParameters parameters) throws IOException {
            this.log.trace("Rendering template: {}, with params: {}", (Object)template, (Object)parameters);
            URL url = ((Object)((Object)this)).getClass().getResource(template);
            return RaptureWebResourceBundle.this.templateHelper.render(url, parameters).getBytes();
        }
    }
}

