/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.branding;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.rapture.internal.branding.BrandingXO;

public class BrandingCapabilityConfiguration
extends BrandingXO {
    public static final String HEADER_ENABLED = "headerEnabled";
    public static final String HEADER_HTML = "headerHtml";
    public static final String FOOTER_ENABLED = "footerEnabled";
    public static final String FOOTER_HTML = "footerHtml";

    public BrandingCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.setHeaderEnabled(this.parseBoolean(properties.get(HEADER_ENABLED), false));
        this.setHeaderHtml(this.parseString(properties.get(HEADER_HTML)));
        this.setFooterEnabled(this.parseBoolean(properties.get(FOOTER_ENABLED), false));
        this.setFooterHtml(this.parseString(properties.get(FOOTER_HTML)));
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        if (!Strings2.isEmpty((String)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private String parseString(String value) {
        if (!Strings2.isEmpty((String)value)) {
            return value;
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "headerEnabled=" + this.getHeaderEnabled() + ", footerEnabled=" + this.getFooterEnabled() + "}";
    }
}

