/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.branding;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.TextAreaFormField;
import org.sonatype.nexus.rapture.internal.branding.BrandingCapabilityConfiguration;

@Named(value="rapture.branding")
@Singleton
public class BrandingCapabilityDescriptor
extends CapabilityDescriptorSupport<BrandingCapabilityConfiguration>
implements Taggable {
    public static final String TYPE_ID = "rapture.branding";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"rapture.branding");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new CheckboxFormField("headerEnabled", messages.headerEnabledLabel(), messages.headerEnabledHelp(), false).withInitialValue(Boolean.valueOf(true)), new TextAreaFormField("headerHtml", messages.headerHtmlLabel(), messages.headerHtmlHelp(), false), new CheckboxFormField("footerEnabled", messages.footerEnabledLabel(), messages.footerEnabledHelp(), false).withInitialValue(Boolean.valueOf(true)), new TextAreaFormField("footerHtml", messages.footerHtmlLabel(), messages.footerHtmlHelp(), false)});

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected BrandingCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new BrandingCapabilityConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("rapture.branding-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"UI")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="UI: Branding")
        public String name();

        @MessageBundle.DefaultMessage(value="Enable header")
        public String headerEnabledLabel();

        @MessageBundle.DefaultMessage(value="Enable branding header HTML snippet.")
        public String headerEnabledHelp();

        @MessageBundle.DefaultMessage(value="Header HTML snippet")
        public String headerHtmlLabel();

        @MessageBundle.DefaultMessage(value="An HTML snippet to be included in branding header. Use '$baseUrl' to insert the base URL of the server (e.g. to reference an image)")
        public String headerHtmlHelp();

        @MessageBundle.DefaultMessage(value="Enable footer")
        public String footerEnabledLabel();

        @MessageBundle.DefaultMessage(value="Enable branding footer HTML snippet.")
        public String footerEnabledHelp();

        @MessageBundle.DefaultMessage(value="Footer HTML snippet")
        public String footerHtmlLabel();

        @MessageBundle.DefaultMessage(value="An HTML snippet to be included in branding footer. Use '$baseUrl' to insert the base URL of the server (e.g. to reference an image)")
        public String footerHtmlHelp();
    }
}

