/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.logging;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.gossip.Level;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.rapture.internal.logging.LogEventXO;

@Named
@Singleton
@DirectAction(action={"rapture_LogEvent"})
public class LogEventComponent
extends DirectComponentSupport {
    private static final Map<String, Level> levels = ImmutableMap.of((Object)"trace", (Object)Level.TRACE, (Object)"debug", (Object)Level.DEBUG, (Object)"info", (Object)Level.INFO, (Object)"warn", (Object)Level.WARN, (Object)"error", (Object)Level.ERROR);

    @DirectMethod
    @Timed
    @ExceptionMetered
    public void recordEvent(LogEventXO event) {
        Preconditions.checkNotNull((Object)event);
        Level level = levels.get(event.getLevel());
        Preconditions.checkState((level != null ? 1 : 0) != 0, (String)"Invalid level: %s", (Object)event.getLevel());
        Logger logger = LoggerFactory.getLogger((String)event.getLogger());
        level.log(logger, event.getMessage());
    }
}

