/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.settings;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.rapture.internal.settings.Rapture;
import org.sonatype.nexus.rapture.internal.settings.SettingsCapabilityConfiguration;

@Named(value="rapture.settings")
public class SettingsCapability
extends CapabilitySupport<SettingsCapabilityConfiguration> {
    private final Rapture rapture;

    @Inject
    public SettingsCapability(Rapture rapture) {
        this.rapture = (Rapture)((Object)Preconditions.checkNotNull((Object)((Object)rapture)));
    }

    protected SettingsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new SettingsCapabilityConfiguration(properties);
    }

    protected void onActivate(SettingsCapabilityConfiguration config) throws Exception {
        this.rapture.setSettings(config);
    }

    protected void onPassivate(SettingsCapabilityConfiguration config) throws Exception {
        this.rapture.resetSettings();
    }

    protected void onRemove(SettingsCapabilityConfiguration config) throws Exception {
        this.rapture.resetSettings();
    }

    public Condition activationCondition() {
        return this.conditions().capabilities().passivateCapabilityDuringUpdate();
    }
}

