/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.settings;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.rapture.internal.settings.RaptureSettings;

public class SettingsCapabilityConfiguration
extends RaptureSettings {
    public static final String DEBUG_ALLOWED = "debugAllowed";
    public static final String STATUS_INTERVAL_AUTHENTICATED = "statusIntervalAuthenticated";
    public static final String STATUS_INTERVAL_ANONYMOUS = "statusIntervalAnonymous";
    public static final String SESSION_TIMEOUT = "sessionTimeout";
    public static final String REQUEST_TIMEOUT = "requestTimeout";
    public static final String LONG_REQUEST_TIMEOUT = "longRequestTimeout";
    public static final String TITLE = "title";

    public SettingsCapabilityConfiguration() {
        this(Maps.newHashMap());
    }

    public SettingsCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.setDebugAllowed(this.parseBoolean(properties.get(DEBUG_ALLOWED), true));
        this.setStatusIntervalAuthenticated(this.parseInteger(properties.get(STATUS_INTERVAL_AUTHENTICATED), 5));
        this.setStatusIntervalAnonymous(this.parseInteger(properties.get(STATUS_INTERVAL_ANONYMOUS), 60));
        this.setSessionTimeout(this.parseInteger(properties.get(SESSION_TIMEOUT), 30));
        this.setRequestTimeout(this.parseInteger(properties.get(REQUEST_TIMEOUT), 60));
        this.setLongRequestTimeout(this.parseInteger(properties.get(LONG_REQUEST_TIMEOUT), 180));
        this.setTitle(this.parseString(properties.get(TITLE), "Nexus Repository Manager"));
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(DEBUG_ALLOWED, Boolean.toString(this.isDebugAllowed()));
        props.put(STATUS_INTERVAL_AUTHENTICATED, Integer.toString(this.getStatusIntervalAuthenticated()));
        props.put(STATUS_INTERVAL_ANONYMOUS, Integer.toString(this.getStatusIntervalAnonymous()));
        props.put(SESSION_TIMEOUT, Integer.toString(this.getSessionTimeout()));
        props.put(REQUEST_TIMEOUT, Integer.toString(this.getRequestTimeout()));
        props.put(LONG_REQUEST_TIMEOUT, Integer.toString(this.getLongRequestTimeout()));
        props.put(TITLE, this.getTitle());
        return props;
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        if (!this.isEmpty(value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private int parseInteger(String value, int defaultValue) {
        if (!this.isEmpty(value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    private String parseString(String value, String defaultValue) {
        if (!this.isEmpty(value)) {
            return value;
        }
        return defaultValue;
    }

    private boolean isEmpty(String value) {
        return Strings2.isEmpty((String)value);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "title=" + this.getTitle() + ", debugAllowed=" + this.isDebugAllowed() + ", statusIntervalAuthenticated=" + this.getStatusIntervalAuthenticated() + ", statusIntervalAnonymous=" + this.getStatusIntervalAnonymous() + ", sessionTimeout=" + this.getSessionTimeout() + ", requestTimeout=" + this.getRequestTimeout() + ", longRequestTimeout=" + this.getLongRequestTimeout() + "}";
    }
}

