/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.StateContributor;

@Named
@Singleton
public class ActiveBundlesStateContributor
extends ComponentSupport
implements StateContributor {
    public static final String STATE_ID = "activeBundles";
    private final Set<String> activeBundles = new ConcurrentSkipListSet<String>();

    @Inject
    public ActiveBundlesStateContributor(BundleContext bundleContext) {
        Preconditions.checkNotNull((Object)bundleContext);
        new BundleTracker<String>(bundleContext, 32, null){

            public String addingBundle(Bundle bundle, BundleEvent event) {
                String name = bundle.getSymbolicName();
                String location = bundle.getLocation();
                if (location.startsWith("wrap:mvn")) {
                    return null;
                }
                ActiveBundlesStateContributor.this.activeBundles.add(name);
                return name;
            }

            public void removedBundle(Bundle bundle, BundleEvent event, String name) {
                ActiveBundlesStateContributor.this.activeBundles.remove(name);
            }
        }.open();
    }

    @Override
    public Map<String, Object> getState() {
        return ImmutableMap.of((Object)STATE_ID, this.activeBundles);
    }
}

