/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.state;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectPollMethod;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.rapture.internal.state.StateValueXO;

@Named
@Singleton
@DirectAction(action={"rapture_State"})
public class StateComponent
extends DirectComponentSupport {
    private static final Logger log = LoggerFactory.getLogger(StateComponent.class);
    private final String serverId;
    private final List<Provider<StateContributor>> stateContributors;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Inject
    public StateComponent(List<Provider<StateContributor>> stateContributors, NodeAccess nodeAccess) {
        this.stateContributors = (List)Preconditions.checkNotNull(stateContributors);
        String prefix = ((NodeAccess)Preconditions.checkNotNull((Object)nodeAccess)).isClustered() ? "ignore." : "";
        this.serverId = String.valueOf(prefix) + String.valueOf(System.nanoTime());
    }

    @Timed
    @ExceptionMetered
    @DirectPollMethod(event="rapture_State_get")
    public Map<String, Object> getState(Map<String, String> hashes) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String string : hashes.keySet()) {
            values.put(string, null);
        }
        for (Provider provider : this.stateContributors) {
            try {
                Map<String, Object> stateValues = ((StateContributor)provider.get()).getState();
                if (stateValues == null) continue;
                for (Map.Entry<String, Object> entry : stateValues.entrySet()) {
                    if (!Strings2.isBlank((String)entry.getKey())) {
                        this.maybeSend(values, hashes, entry.getKey(), entry.getValue());
                        continue;
                    }
                    log.warn("Blank state-id returned by {} (ignored)", (Object)provider.getClass().getName());
                }
            }
            catch (Exception e) {
                log.warn("Failed to get state from {} (ignored)", (Object)provider.getClass().getName(), (Object)e);
            }
        }
        this.maybeSend(values, hashes, "serverId", this.serverId);
        return values;
    }

    private void maybeSend(Map<String, Object> values, Map<String, String> hashes, String key, Object value) {
        values.remove(key);
        String hash = StateComponent.hash(value);
        if (!Objects.equal((Object)hash, (Object)hashes.get(key))) {
            StateValueXO data = new StateValueXO();
            data.setHash(hash);
            data.setValue(value);
            values.put(key, data);
        }
    }

    @Nullable
    private static String hash(@Nullable Object value) {
        if (value != null) {
            String json = gson.toJson(value);
            log.trace("Hashing state: {}", (Object)json);
            return Hashing.sha1().hashString((CharSequence)json, StandardCharsets.UTF_8).toString();
        }
        return null;
    }
}

