/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rapture.internal.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.rapture.internal.state.StatusXO;

@Named
@Singleton
public class StatusStateContributor
extends ComponentSupport
implements StateContributor {
    private static final String STATE_ID = "status";
    private final ApplicationVersion applicationVersion;

    @Inject
    public StatusStateContributor(ApplicationVersion applicationVersion) {
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
    }

    @Override
    @Nullable
    public Map<String, Object> getState() {
        return ImmutableMap.of((Object)STATE_ID, (Object)this.calculateStatus());
    }

    private Object calculateStatus() {
        StatusXO result = new StatusXO();
        result.setVersion(this.applicationVersion.getVersion());
        result.setEdition(this.applicationVersion.getEdition());
        result.setBuildRevision(this.applicationVersion.getBuildRevision());
        result.setBuildTimestamp(this.applicationVersion.getBuildTimestamp());
        return result;
    }
}

