/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.raw.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.raw.internal.RawRestoreBlobData;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.raw.RawContentFacet;
import org.sonatype.nexus.repository.storage.AssetBlob;

@Named(value="raw")
@Singleton
public class RawRestoreBlobStrategy
extends BaseRestoreBlobStrategy<RawRestoreBlobData> {
    private final AttributesMap NO_CONTENT_ATTRIBUTES = null;

    @Inject
    public RawRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
    }

    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.MD5);
    }

    protected RawRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return new RawRestoreBlobData(blobData);
    }

    protected boolean canAttemptRestore(RawRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        if (!repository.optionalFacet(RawContentFacet.class).isPresent()) {
            this.log.warn("Skipping as Raw Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(RawRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    protected boolean assetExists(RawRestoreBlobData data) {
        return this.getRawContentFacet(data).assetExists(data.getBlobData().getBlobName());
    }

    protected void createAssetFromBlob(AssetBlob assetBlob, RawRestoreBlobData data) {
        this.getRawContentFacet(data).put(this.getAssetPath(data), assetBlob, this.NO_CONTENT_ATTRIBUTES);
    }

    private RawContentFacet getRawContentFacet(RawRestoreBlobData data) {
        return (RawContentFacet)data.getBlobData().getRepository().facet(RawContentFacet.class);
    }
}

