/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

public class CancelableHelper {
    private static final ThreadLocal<AtomicBoolean> currentFlagHolder = new ThreadLocal();

    private CancelableHelper() {
    }

    public static void set(AtomicBoolean flag) {
        Preconditions.checkNotNull((Object)flag);
        currentFlagHolder.set(flag);
    }

    public static void remove() {
        currentFlagHolder.remove();
    }

    public static void checkCancellation() {
        Thread.yield();
        AtomicBoolean current = currentFlagHolder.get();
        if (current != null && current.get()) {
            throw new TaskInterruptedException("Thread '" + Thread.currentThread().getName() + "' is canceled", true);
        }
        if (Thread.interrupted()) {
            throw new TaskInterruptedException("Thread '" + Thread.currentThread().getName() + "' is interrupted", false);
        }
    }
}

