/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.TaskInfo;

public class ClusteredTaskState {
    private final String nodeId;
    private final TaskInfo.State state;
    private final TaskInfo.RunState runState;
    private final TaskInfo.EndState lastEndState;
    private final Date lastRunStarted;
    private final Long lastRunDuration;

    public ClusteredTaskState(String nodeId, TaskInfo.State state, @Nullable TaskInfo.RunState runState, @Nullable TaskInfo.EndState lastEndState, @Nullable Date lastRunStarted, @Nullable Long lastRunDuration) {
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
        this.state = (TaskInfo.State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
        this.runState = runState;
        this.lastEndState = lastEndState;
        this.lastRunStarted = lastRunStarted;
        this.lastRunDuration = lastRunDuration;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public TaskInfo.State getState() {
        return this.state;
    }

    @Nullable
    public TaskInfo.RunState getRunState() {
        return this.runState;
    }

    @Nullable
    public TaskInfo.EndState getLastEndState() {
        return this.lastEndState;
    }

    @Nullable
    public Date getLastRunStarted() {
        return this.lastRunStarted;
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.lastRunDuration;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{nodeId=" + this.nodeId + ", state=" + (Object)((Object)this.state) + ", runState=" + (Object)((Object)this.runState) + ", lastEndState=" + (Object)((Object)this.lastEndState) + ", lastRunStarted=" + this.lastRunStarted + ", lastRunDuration=" + this.lastRunDuration + "}";
    }
}

