/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.logging.task.TaskLogInfo;

public class TaskConfiguration
implements TaskLogInfo {
    private static final String ID_KEY = ".id";
    private static final String NAME_KEY = ".name";
    private static final String TYPE_ID_KEY = ".typeId";
    private static final String TYPE_NAME_KEY = ".typeName";
    private static final String ENABLED_KEY = ".enabled";
    private static final String VISIBLE_KEY = ".visible";
    private static final String ALERT_EMAIL_KEY = ".alertEmail";
    private static final String CREATED_KEY = ".created";
    private static final String UPDATED_KEY = ".updated";
    private static final String MESSAGE_KEY = ".message";
    private static final String REQUEST_RECOVERY = ".recoverable";
    private final Map<String, String> configuration;

    public TaskConfiguration() {
        this.configuration = new HashMap<String, String>();
    }

    public TaskConfiguration(TaskConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configuration = new HashMap<String, String>(configuration.configuration);
        this.validate();
    }

    public void validate() {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getId()) ? 1 : 0) != 0, (Object)"Incomplete task configuration: id");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTypeId()) ? 1 : 0) != 0, (Object)"Incomplete task configuration: typeId");
        for (Map.Entry<String, String> entry : this.configuration.entrySet()) {
            Preconditions.checkArgument((entry.getKey() instanceof String && entry.getValue() instanceof String ? 1 : 0) != 0, (String)"Invalid entry in map: %s", this.configuration);
        }
    }

    public String getTaskLogName() {
        String name = Strings.isNullOrEmpty((String)this.getName()) ? this.getTypeName() : this.getName();
        return String.format("'%s' [%s]", name, this.getTypeId());
    }

    public TaskConfiguration apply(TaskConfiguration from) {
        Preconditions.checkNotNull((Object)from);
        from.validate();
        this.configuration.putAll(from.configuration);
        return this;
    }

    public Map<String, String> asMap() {
        return ImmutableMap.copyOf(this.configuration);
    }

    public String toString() {
        return this.configuration.toString();
    }

    public String getId() {
        return this.getString(ID_KEY);
    }

    public void setId(String id) {
        Preconditions.checkNotNull((Object)id);
        this.configuration.put(ID_KEY, id);
    }

    public String getName() {
        return this.getString(NAME_KEY);
    }

    public void setName(String name) {
        Preconditions.checkNotNull((Object)name);
        this.configuration.put(NAME_KEY, name);
    }

    public String getTypeId() {
        return this.getString(TYPE_ID_KEY);
    }

    public void setTypeId(String typeId) {
        Preconditions.checkNotNull((Object)typeId);
        this.configuration.put(TYPE_ID_KEY, typeId);
    }

    public String getTypeName() {
        return this.getString(TYPE_NAME_KEY);
    }

    public void setTypeName(String typeName) {
        Preconditions.checkNotNull((Object)typeName);
        this.configuration.put(TYPE_NAME_KEY, typeName);
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLED_KEY, true);
    }

    public void setEnabled(boolean enabled) {
        this.configuration.put(ENABLED_KEY, Boolean.toString(enabled));
    }

    public boolean isVisible() {
        return this.getBoolean(VISIBLE_KEY, true);
    }

    public void setVisible(boolean visible) {
        this.configuration.put(VISIBLE_KEY, Boolean.toString(visible));
    }

    @Nullable
    public String getAlertEmail() {
        return this.getString(ALERT_EMAIL_KEY);
    }

    public void setAlertEmail(String email) {
        if (Strings.isNullOrEmpty((String)email)) {
            this.configuration.remove(ALERT_EMAIL_KEY);
        } else {
            this.configuration.put(ALERT_EMAIL_KEY, email);
        }
    }

    @Nullable
    public Date getCreated() {
        return this.getDate(CREATED_KEY, null);
    }

    public void setCreated(Date date) {
        Preconditions.checkNotNull((Object)date);
        this.setDate(CREATED_KEY, date);
    }

    @Nullable
    public Date getUpdated() {
        return this.getDate(UPDATED_KEY, null);
    }

    public void setUpdated(Date date) {
        Preconditions.checkNotNull((Object)date);
        this.setDate(UPDATED_KEY, date);
    }

    @Nullable
    public String getMessage() {
        return this.getString(MESSAGE_KEY);
    }

    public void setMessage(String message) {
        if (Strings.isNullOrEmpty((String)message)) {
            this.configuration.remove(MESSAGE_KEY);
        } else {
            this.configuration.put(MESSAGE_KEY, message);
        }
    }

    public boolean isRecoverable() {
        return this.getBoolean(REQUEST_RECOVERY, false);
    }

    public void setRecoverable(boolean requestRecovery) {
        this.configuration.put(REQUEST_RECOVERY, Boolean.toString(requestRecovery));
    }

    public Date getDate(String key, Date defaultValue) {
        if (this.configuration.containsKey(key)) {
            return new DateTime((Object)this.getString(key)).toDate();
        }
        return defaultValue;
    }

    public void setDate(String key, Date date) {
        Preconditions.checkNotNull((Object)key);
        if (date == null) {
            this.configuration.remove(key);
        } else {
            this.configuration.put(key, new DateTime((Object)date).toString());
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(key, String.valueOf(defaultValue)));
    }

    public void setBoolean(String key, boolean value) {
        Preconditions.checkNotNull((Object)key);
        this.configuration.put(key, String.valueOf(value));
    }

    public int getInteger(String key, int defaultValue) {
        return Integer.parseInt(this.getString(key, String.valueOf(defaultValue)));
    }

    public void setInteger(String key, int value) {
        Preconditions.checkNotNull((Object)key);
        this.configuration.put(key, String.valueOf(value));
    }

    public long getLong(String key, long defaultValue) {
        return Long.parseLong(this.getString(key, String.valueOf(defaultValue)));
    }

    public void setLong(String key, long value) {
        Preconditions.checkNotNull((Object)key);
        this.configuration.put(key, String.valueOf(value));
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Preconditions.checkNotNull((Object)key);
        if (this.configuration.containsKey(key)) {
            return this.configuration.get(key);
        }
        return defaultValue;
    }

    public void setString(String key, String value) {
        Preconditions.checkNotNull((Object)key);
        if (value == null) {
            this.configuration.remove(key);
        } else {
            this.configuration.put(key, value);
        }
    }

    public boolean containsKey(String key) {
        Preconditions.checkNotNull((Object)key);
        return this.configuration.containsKey(key);
    }
}

