/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.scheduling.Task;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptor;

public abstract class TaskDescriptorSupport
implements TaskDescriptor {
    public static final String MULTINODE_KEY = "multinode";
    public static final String MULTINODE_LABEL = "Multi node";
    public static final String MULTINODE_HELP = "Run task on all nodes in the cluster.";
    public static final String LIMIT_NODE_KEY = "limitnode";
    public static final String LIMIT_NODE_LABEL = "Select node";
    public static final String LIMIT_NODE_HELP = "Run task on this node in the cluster.";
    protected static final boolean VISIBLE = true;
    protected static final boolean NOT_VISIBLE = false;
    protected static final boolean EXPOSED = true;
    protected static final boolean NOT_EXPOSED = false;
    private final String id;
    private final String name;
    private final Class<? extends Task> type;
    private final boolean visible;
    private final boolean exposed;
    private final boolean requestRecovery;
    private final List<FormField> formFields;

    public TaskDescriptorSupport(String id, Class<? extends Task> type, String name, boolean visible, boolean exposed, FormField ... formFields) {
        this(id, type, name, visible, exposed, false, formFields);
    }

    public TaskDescriptorSupport(String id, Class<? extends Task> type, String name, boolean visible, boolean exposed, boolean requestRecovery, FormField ... formFields) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.type = (Class)Preconditions.checkNotNull(type);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.visible = visible;
        this.exposed = exposed;
        this.requestRecovery = requestRecovery;
        Preconditions.checkNotNull((Object)formFields);
        this.formFields = Arrays.stream(formFields).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Class<? extends Task> getType() {
        return this.type;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isExposed() {
        return this.exposed;
    }

    @Override
    public final List<FormField> getFormFields() {
        return this.formFields;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + this.type + ", visible=" + this.visible + ", exposed=" + this.exposed + '}';
    }

    @Override
    public void initializeConfiguration(TaskConfiguration configuration) {
    }

    protected static CheckboxFormField newMultinodeFormField() {
        return new CheckboxFormField(MULTINODE_KEY, MULTINODE_LABEL, MULTINODE_HELP, false);
    }

    protected static ComboboxFormField<String> newLimitNodeFormField() {
        return new ComboboxFormField(LIMIT_NODE_KEY, LIMIT_NODE_LABEL, LIMIT_NODE_HELP, true).withStoreApi("node_NodeAccess.nodes").withIdMapping("name").withNameMapping("displayName");
    }

    @Override
    public boolean isRecoverable() {
        return this.requestRecovery;
    }
}

