/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import java.util.Date;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskRemovedException;
import org.sonatype.nexus.scheduling.schedule.Schedule;

public interface TaskInfo {
    public String getId();

    public String getName();

    public String getTypeId();

    public String getMessage();

    public TaskConfiguration getConfiguration();

    public Schedule getSchedule();

    public CurrentState getCurrentState();

    @Nullable
    public LastRunState getLastRunState();

    public boolean remove();

    public TaskInfo runNow(@Nullable String var1) throws TaskRemovedException;

    default public TaskInfo runNow() throws TaskRemovedException {
        return this.runNow(null);
    }

    @Nullable
    public String getTriggerSource();

    public static interface CurrentState {
        public State getState();

        @Nullable
        public Date getNextRun();

        @Nullable
        public Date getRunStarted();

        @Nullable
        public RunState getRunState();

        @Nullable
        public Future<?> getFuture();
    }

    public static enum EndState {
        OK,
        FAILED,
        CANCELED,
        INTERRUPTED;

    }

    public static interface LastRunState {
        public EndState getEndState();

        public Date getRunStarted();

        public long getRunDuration();
    }

    public static enum RunState {
        STARTING,
        BLOCKED,
        RUNNING,
        CANCELED;

    }

    public static enum State {
        WAITING,
        RUNNING,
        DONE;

    }
}

