/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.logging.task.TaskLogInfo;
import org.sonatype.nexus.logging.task.TaskLogger;
import org.sonatype.nexus.logging.task.TaskLoggerFactory;
import org.sonatype.nexus.logging.task.TaskLoggerHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.Task;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

public abstract class TaskSupport
extends ComponentSupport
implements Task {
    private final TaskConfiguration configuration = this.createTaskConfiguration();
    private final AtomicBoolean canceledFlag = new AtomicBoolean(false);

    protected TaskConfiguration createTaskConfiguration() {
        return new TaskConfiguration();
    }

    protected TaskConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public TaskConfiguration taskConfiguration() {
        return new TaskConfiguration(this.configuration);
    }

    @Override
    public void configure(TaskConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        configuration.validate();
        this.configuration.apply(configuration);
        String message = this.getMessage();
        if (!Strings.isNullOrEmpty((String)message)) {
            this.configuration.setMessage(message);
        }
    }

    @Override
    public String getId() {
        return this.getConfiguration().getId();
    }

    @Override
    public String getName() {
        return this.getConfiguration().getName();
    }

    @Override
    public final Object call() throws Exception {
        this.startTaskLogging();
        CancelableHelper.set(this.canceledFlag);
        try {
            Object object = this.execute();
            return object;
        }
        catch (TaskInterruptedException e) {
            this.log.warn(TaskLoggingMarkers.TASK_LOG_ONLY, "Task '{}' was canceled", (Object)this.getMessage());
            throw e;
        }
        catch (Exception e) {
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Failed to run task '{}'", (Object)this.getMessage(), (Object)e);
            throw e;
        }
        finally {
            CancelableHelper.remove();
            this.finishTaskLogging();
        }
    }

    private void startTaskLogging() {
        TaskLoggerHelper.start((TaskLogger)TaskLoggerFactory.create((Object)this, (Logger)this.log, (TaskLogInfo)this.configuration));
    }

    private void finishTaskLogging() {
        TaskLoggerHelper.finish();
    }

    protected abstract Object execute() throws Exception;

    public void cancel() {
        this.canceledFlag.set(true);
    }

    public boolean isCanceled() {
        return this.canceledFlag.get();
    }

    public String toString() {
        return String.format("%s(id=%s, name=%s)", this.getClass().getSimpleName(), this.getId(), this.getName());
    }
}

