/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.concurrent.Future;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeChangeEvent;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.spi.SchedulerSPI;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Priority(value=-2147483648)
@Singleton
public class TaskActivation
extends StateGuardLifecycleSupport
implements EventAware {
    private final SchedulerSPI scheduler;
    private final DatabaseFreezeService databaseFreezeService;

    @Inject
    public TaskActivation(SchedulerSPI scheduler, DatabaseFreezeService databaseFreezeService) {
        this.scheduler = (SchedulerSPI)Preconditions.checkNotNull((Object)scheduler);
        this.databaseFreezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)databaseFreezeService);
    }

    protected void doStart() throws Exception {
        if (!this.databaseFreezeService.isFrozen()) {
            this.scheduler.resume();
        }
    }

    protected void doStop() throws Exception {
        this.scheduler.pause();
    }

    @Subscribe
    public void onDatabaseFreezeChangeEvent(DatabaseFreezeChangeEvent databaseFreezeChangeEvent) {
        if (databaseFreezeChangeEvent.isFrozen()) {
            this.scheduler.pause();
            this.scheduler.listsTasks().stream().filter(taskInfo -> !this.maybeCancel((TaskInfo)taskInfo)).forEach(taskInfo -> this.log.warn("Unable to cancel task: {}", (Object)taskInfo.getName()));
        } else {
            this.scheduler.resume();
        }
    }

    private boolean maybeCancel(TaskInfo taskInfo) {
        Future<?> future = taskInfo.getCurrentState().getFuture();
        return future == null || future.cancel(false);
    }
}

