/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.Task;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskDescriptor;
import org.sonatype.nexus.scheduling.TaskFactory;

@Named
@Singleton
public class TaskFactoryImpl
extends ComponentSupport
implements TaskFactory {
    private final BeanLocator beanLocator;
    private final Map<String, TaskDefinition> taskDefinitions = Maps.newConcurrentMap();

    @Inject
    public TaskFactoryImpl(BeanLocator beanLocator) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        beanLocator.watch(Key.get(TaskDescriptor.class, Named.class), (Mediator)new TaskDescriptorMediator(), (Object)this);
    }

    @VisibleForTesting
    void addDescriptor(TaskDescriptor descriptor) {
        String typeId = descriptor.getId();
        this.log.debug("Adding task type-id: {}", (Object)typeId);
        Class<? extends Task> type = descriptor.getType();
        this.log.debug("Resolving task bean-entry for type-id {} of type: {}", (Object)typeId, (Object)type.getName());
        Iterator entries = this.beanLocator.locate(Key.get(type)).iterator();
        if (!entries.hasNext()) {
            this.log.warn("Missing task-component for type-id: {}; ignoring it", (Object)typeId);
            return;
        }
        BeanEntry entry = (BeanEntry)entries.next();
        if (entry.getImplementationClass().getAnnotation(Singleton.class) != null) {
            this.log.warn("Task type-id {} implementation {} is singleton; ignoring it", (Object)typeId, (Object)entry.getImplementationClass().getName());
            return;
        }
        this.log.debug("Adding task type-id: {} -> {}", (Object)typeId, (Object)entry.getImplementationClass().getName());
        TaskDefinition prevTaskDefinition = this.taskDefinitions.put(typeId, new TaskDefinition(descriptor, entry));
        if (prevTaskDefinition != null) {
            this.log.warn("Duplicate task type-id {} implementations: {} replaced by {}", new Object[]{typeId, prevTaskDefinition.descriptor.getType().getName(), descriptor.getType().getName()});
        }
    }

    @VisibleForTesting
    void removeDescriptor(String typeId) {
        this.log.debug("Removing task type-id: {}", (Object)typeId);
        this.taskDefinitions.remove(typeId);
    }

    @VisibleForTesting
    Task newInstance(String typeId) {
        TaskDefinition taskDefinition = this.taskDefinitions.get(typeId);
        Preconditions.checkArgument((taskDefinition != null ? 1 : 0) != 0, (String)"Unknown task type-id: %s", (Object)typeId);
        Class<? extends Task> type = taskDefinition.descriptor.getType();
        return type.cast(taskDefinition.beanEntry.getProvider().get());
    }

    @Override
    public List<TaskDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.taskDefinitions.values().stream().map(d -> ((TaskDefinition)d).descriptor).collect(Collectors.toList()));
    }

    @Override
    @Nullable
    public TaskDescriptor findDescriptor(String typeId) {
        TaskDefinition taskDefinition = this.taskDefinitions.get(typeId);
        if (taskDefinition != null) {
            return taskDefinition.descriptor;
        }
        return null;
    }

    @Override
    public Task create(TaskConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.log.debug("Creating task instance: {}", (Object)config);
        config.validate();
        Task task = this.newInstance(config.getTypeId());
        task.configure(config);
        return task;
    }

    private static class TaskDefinition {
        private final TaskDescriptor descriptor;
        private final BeanEntry<Annotation, ? extends Task> beanEntry;

        private TaskDefinition(TaskDescriptor descriptor, BeanEntry<Annotation, ? extends Task> beanEntry) {
            this.descriptor = (TaskDescriptor)Preconditions.checkNotNull((Object)descriptor);
            this.beanEntry = (BeanEntry)Preconditions.checkNotNull(beanEntry);
        }
    }

    private static class TaskDescriptorMediator
    implements Mediator<Named, TaskDescriptor, TaskFactoryImpl> {
        private TaskDescriptorMediator() {
        }

        public void add(BeanEntry<Named, TaskDescriptor> entry, TaskFactoryImpl watcher) throws Exception {
            watcher.addDescriptor((TaskDescriptor)entry.getValue());
        }

        public void remove(BeanEntry<Named, TaskDescriptor> entry, TaskFactoryImpl watcher) throws Exception {
            watcher.removeDescriptor(((TaskDescriptor)entry.getValue()).getId());
        }
    }
}

