/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.schedule;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.time.DateTime;

public abstract class Schedule {
    public static final String SCHEDULE_TYPE = "schedule.type";
    public static final String SCHEDULE_START_AT = "schedule.startAt";
    public static final String SCHEDULE_DAYS_TO_RUN = "schedule.daysToRun";
    private final Map<String, String> properties = new HashMap<String, String>();

    protected Schedule(String type) {
        Preconditions.checkNotNull((Object)type);
        this.set(SCHEDULE_TYPE, type);
    }

    public String getType() {
        return this.properties.get(SCHEDULE_TYPE);
    }

    protected String get(String name) {
        return this.properties.get(name);
    }

    protected void set(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "properties=" + this.properties + '}';
    }

    public static String dateToString(Date date) {
        return new DateTime((Object)date).toString();
    }

    public static Date stringToDate(String string) {
        return DateTime.parse((String)string).toDate();
    }

    public static <T extends Comparable<T>> String setToCsv(Set<T> set, Function<T, String> function) {
        return new TreeSet<T>(set).stream().map(function).collect(Collectors.joining(","));
    }

    public static <T extends Comparable<T>> Set<T> csvToSet(String csv, Function<String, T> function) {
        return Splitter.on((char)',').splitToList((CharSequence)csv).stream().map(function).collect(Collectors.toCollection(TreeSet::new));
    }
}

