/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.blobstore.restore.RubygemsRestoreBlobData;
import com.sonatype.nexus.blobstore.restore.RubygemsRestoreBlobDataFactory;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rubygems.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.RubygemsRepairMetadata;
import org.sonatype.nexus.repository.storage.AssetBlob;

@Named(value="rubygems")
@Singleton
public class RubygemsRestoreBlobStrategy
extends BaseRestoreBlobStrategy<RubygemsRestoreBlobData> {
    private final RubygemsRestoreBlobDataFactory rubygemsRestoreBlobDataFactory;
    private final RubygemsRepairMetadata rubygemsRepairMetadata;

    @Inject
    public RubygemsRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix, RubygemsRestoreBlobDataFactory rubygemsRestoreBlobDataFactory, RubygemsRepairMetadata rubygemsRepairMetadata) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.rubygemsRestoreBlobDataFactory = (RubygemsRestoreBlobDataFactory)Preconditions.checkNotNull((Object)rubygemsRestoreBlobDataFactory);
        this.rubygemsRepairMetadata = (RubygemsRepairMetadata)Preconditions.checkNotNull((Object)rubygemsRepairMetadata);
    }

    protected RubygemsRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return this.rubygemsRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull RubygemsRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional rubygemsContentFacet = repository.optionalFacet(RubygemsContentFacet.class);
        if (!rubygemsContentFacet.isPresent()) {
            this.log.warn("Skipping as RubygemsContentFacet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull RubygemsRestoreBlobData data) {
        return data.getPath();
    }

    protected boolean assetExists(@Nonnull RubygemsRestoreBlobData data) {
        RestoreBlobData blobData = data.getBlobData();
        Repository repository = blobData.getRepository();
        RubygemsContentFacet rubygemsContentFacet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        return rubygemsContentFacet.assetExists(blobData.getBlobName(), data.getAssetKind());
    }

    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull RubygemsRestoreBlobData restoreBlobData) throws IOException {
        Repository repository = restoreBlobData.getBlobData().getRepository();
        RubygemsContentFacet facet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        switch (restoreBlobData.getAssetKind()) {
            case GEM: {
                facet.restoreGem(restoreBlobData.getGemCoordinate(), assetBlob);
                break;
            }
            case GEMSPEC: {
                facet.restoreGemSpec(restoreBlobData.getGemCoordinate(), assetBlob);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: {
                facet.restoreBundlerApi(restoreBlobData.getPath(), assetBlob);
                break;
            }
            case SPECS_INDEX: {
                facet.restoreSpecsIndex(restoreBlobData.getPath(), assetBlob);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Nonnull
    protected List<HashAlgorithm> getHashAlgorithms() {
        return Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA1, HashAlgorithm.MD5});
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.rubygemsRepairMetadata.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of Rubygems metadata");
        }
    }
}

