/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.sonatype.clm.dto.model.component.ComponentDisplayName;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import java.util.Map;

public class ComponentDisplayNameUtil {
    public static final String GAV_SEPARATOR = " : ";
    public static final String NUGET_SEPARATOR = " ";
    public static final String ANAME_SEPARATOR = " ";
    public static final String GROUP_LABEL = "Group";
    public static final String ARTIFACT_LABEL = "Artifact";
    public static final String VERSION_LABEL = "Version";
    public static final String EXTENSION_LABEL = "Extension";
    public static final String CLASSIFIER_LABEL = "Classifier";
    public static final String ID_LABEL = "ID";
    public static final String NAME_LABEL = "Name";
    public static final String QUALIFIER_LABEL = "Qualifier";
    public static final String ARCHITECTURE_LABEL = "Architecture";
    public static final String PLATFORM_LABEL = "Platform";

    private static ComponentDisplayName fromGavec(String groupId, String artifactId, String version, String extension, String classifier) {
        boolean showExtension;
        if (groupId == null) {
            return null;
        }
        ComponentDisplayName componentDisplayName = new ComponentDisplayName().add(GROUP_LABEL, groupId).add(GAV_SEPARATOR).add(ARTIFACT_LABEL, artifactId);
        boolean hasClassifier = classifier != null && !classifier.isEmpty();
        boolean bl = showExtension = extension != null && !extension.isEmpty() && (!extension.equalsIgnoreCase("jar") || hasClassifier);
        if (showExtension) {
            componentDisplayName.add(GAV_SEPARATOR).add(EXTENSION_LABEL, extension);
        } else if (hasClassifier) {
            componentDisplayName.add(GAV_SEPARATOR);
        }
        if (hasClassifier) {
            componentDisplayName.add(GAV_SEPARATOR).add(CLASSIFIER_LABEL, classifier);
        }
        return componentDisplayName.add(GAV_SEPARATOR).add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromNuGet(String packageId, String version) {
        return new ComponentDisplayName().add(ID_LABEL, packageId).add(" ").add(VERSION_LABEL, version);
    }

    private static ComponentDisplayName fromAname(String name, String version, String qualifier) {
        ComponentDisplayName displayName = new ComponentDisplayName().add(NAME_LABEL, name);
        if (qualifier != null && !qualifier.isEmpty()) {
            displayName.add(" ").add("(").add(QUALIFIER_LABEL, qualifier).add(")");
        }
        displayName.add(" ").add(VERSION_LABEL, version);
        return displayName;
    }

    private static ComponentDisplayName fromPypi(String name, String version, String qualifier, String extension) {
        ComponentDisplayName displayName = new ComponentDisplayName().add(NAME_LABEL, name);
        if (qualifier != null && !qualifier.isEmpty()) {
            displayName.add(" (").add(QUALIFIER_LABEL, qualifier).add(")");
        }
        displayName.add(" ").add(VERSION_LABEL, version);
        displayName.add(" (.").add(EXTENSION_LABEL, extension).add(")");
        return displayName;
    }

    private static ComponentDisplayName fromRpm(String name, String version, String architecture) {
        ComponentDisplayName displayName = new ComponentDisplayName().add(NAME_LABEL, name);
        displayName.add("-").add(VERSION_LABEL, version);
        if (architecture != null && !architecture.isEmpty()) {
            displayName.add(".").add(ARCHITECTURE_LABEL, architecture);
        }
        return displayName;
    }

    private static ComponentDisplayName fromRubyGems(String name, String version, String platform) {
        ComponentDisplayName displayName = new ComponentDisplayName().add(NAME_LABEL, name);
        if (platform != null && !"".equals(platform) && !"ruby".equals(platform)) {
            displayName.add(" (").add(PLATFORM_LABEL, platform).add(") ");
        } else {
            displayName.add(" ");
        }
        displayName.add(VERSION_LABEL, version);
        return displayName;
    }

    public static ComponentDisplayName fromIdentifier(ComponentIdentifier identifier) {
        if (identifier == null) {
            return null;
        }
        if (identifier.isMaven()) {
            return ComponentDisplayNameUtil.fromGavec(identifier.get("groupId"), identifier.get("artifactId"), identifier.get("version"), identifier.get("extension"), identifier.get("classifier"));
        }
        if ("nuget".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromNuGet(identifier.get("packageId"), identifier.get("version"));
        }
        if ("a-name".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromAname(identifier.get("name"), identifier.get("version"), identifier.get("qualifier"));
        }
        if ("pypi".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromPypi(identifier.get("name"), identifier.get("version"), identifier.get("qualifier"), identifier.get("extension"));
        }
        if ("rpm".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromRpm(identifier.get("name"), identifier.get("version"), identifier.get("architecture"));
        }
        if ("gem".equals(identifier.getFormat())) {
            return ComponentDisplayNameUtil.fromRubyGems(identifier.get("name"), identifier.get("version"), identifier.get("platform"));
        }
        ComponentDisplayName name = new ComponentDisplayName();
        boolean first = true;
        for (Map.Entry<String, String> entry : identifier.getCoordinates().entrySet()) {
            if (!first) {
                name.add(GAV_SEPARATOR);
            }
            first = false;
            name.add(entry.getKey(), entry.getValue());
        }
        return name;
    }
}

