/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.component;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.sonatype.clm.dto.model.component.InvalidComponentIdentifierException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class ComponentIdentifier
implements Comparable<ComponentIdentifier> {
    static final String MUST_HAVE_FORMAT_MESSAGE = "A component identifier must have a format.";
    static final String MUST_HAVE_COORDINATE_MESSAGE = "A component identifier must have at least one coordinate.";
    static final String INCORRECT_COORDINATES = "Coordinates contain the following incorrect entries for the given format: ";
    static final String MISSING_COORDINATES = "The following coordinates are missing for given format: ";
    private static final SortedMap<String, String> UNMODIFIABLE_EMPTY_SORTED_MAP = Collections.unmodifiableSortedMap(new TreeMap());
    private String format;
    private SortedMap<String, String> coordinates;
    public static final String NPM_PACKAGE_ID = "packageId";
    public static final String NUGET_PACKAGE_ID = "packageId";
    public static final String VERSION = "version";
    public static final String MAVEN_EXTENSION = "extension";
    public static final String MAVEN_CLASSIFIER = "classifier";
    public static final String MAVEN_ARTIFACT_ID = "artifactId";
    public static final String MAVEN_GROUP_ID = "groupId";
    public static final String ANAME_NAME = "name";
    public static final String ANAME_QUALIFIER = "qualifier";
    public static final String PYPI_NAME = "name";
    public static final String PYPI_QUALIFIER = "qualifier";
    public static final String PYPI_EXTENSION = "extension";
    public static final String RPM_NAME = "name";
    public static final String RPM_ARCHITECTURE = "architecture";
    public static final String RUBYGEMS_NAME = "name";
    public static final String RUBYGEMS_PLATFORM = "platform";
    static final String RUBYGEMS_PLATFORM_DEFAULT = "ruby";
    private static final LinkedHashSet<String> MAVEN_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "classifier", "extension"));
    private static final LinkedHashSet<String> MAVEN_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("groupId", "artifactId", "version", "extension"));
    private static final LinkedHashSet<String> ANAME_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "qualifier"));
    private static final LinkedHashSet<String> ANAME_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    private static final LinkedHashSet<String> NPM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NPM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NUGET_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> NUGET_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("packageId", "version"));
    private static final LinkedHashSet<String> PYPI_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "qualifier", "extension"));
    private static final LinkedHashSet<String> PYPI_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version", "extension"));
    private static final LinkedHashSet<String> RPM_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "architecture"));
    private static final LinkedHashSet<String> RPM_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version", "architecture"));
    private static final LinkedHashSet<String> RUBYGEMS_COORDINATE_NAMES = new LinkedHashSet<String>(Arrays.asList("name", "version", "platform"));
    private static final LinkedHashSet<String> RUBYGEMS_REQUIRED_COORDINATES = new LinkedHashSet<String>(Arrays.asList("name", "version"));
    public static final String FORMAT_MAVEN = "maven";
    public static final String FORMAT_NPM = "npm";
    public static final String FORMAT_NUGET = "nuget";
    public static final String FORMAT_ANAME = "a-name";
    public static final String FORMAT_PYPI = "pypi";
    public static final String FORMAT_RPM = "rpm";
    public static final String FORMAT_RUBYGEMS = "gem";
    private static final Map<String, Set<String>> FORMAT_TO_COORDINATES = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> FORMAT_TO_REQUIRED_COORDINATES;

    public ComponentIdentifier() {
    }

    public ComponentIdentifier(String format, Map<String, String> coordinates) {
        this.format = format;
        this.setCoordinates(coordinates);
        this.validate();
    }

    public String get(String property) {
        return (String)this.coordinates.get(property);
    }

    public ComponentIdentifier createAlternativeVersion(String version) {
        LinkedHashMap<String, String> coordinates = new LinkedHashMap<String, String>(this.coordinates);
        coordinates.put(VERSION, version);
        return new ComponentIdentifier(this.format, coordinates);
    }

    public static Set<String> getAllCoordinateNames(String format) {
        if (!FORMAT_TO_COORDINATES.containsKey(format)) {
            return Collections.emptySet();
        }
        return FORMAT_TO_COORDINATES.get(format);
    }

    public static Set<String> getAllRequiredCoordinateNames(String format) {
        if (!FORMAT_TO_REQUIRED_COORDINATES.containsKey(format)) {
            return Collections.emptySet();
        }
        return FORMAT_TO_REQUIRED_COORDINATES.get(format);
    }

    public static ComponentIdentifier createNpmCoordinates(String packageId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("packageId", packageId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_NPM, coords);
    }

    public static ComponentIdentifier createNugetCoordinates(String packageId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("packageId", packageId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_NUGET, coords);
    }

    public static ComponentIdentifier createMavenCoordinates(String groupId, String artifactId, String version, String classifier, String extension) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(MAVEN_GROUP_ID, groupId);
        coords.put(MAVEN_ARTIFACT_ID, artifactId);
        coords.put(VERSION, version);
        coords.put(MAVEN_CLASSIFIER, classifier);
        coords.put("extension", extension);
        return new ComponentIdentifier(FORMAT_MAVEN, coords);
    }

    public static ComponentIdentifier createMavenCoordinates(String groupId, String artifactId, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put(MAVEN_GROUP_ID, groupId);
        coords.put(MAVEN_ARTIFACT_ID, artifactId);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_MAVEN, coords);
    }

    public static ComponentIdentifier createAnameCoordinates(String name, String qualifier, String version) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put("qualifier", qualifier);
        coords.put(VERSION, version);
        return new ComponentIdentifier(FORMAT_ANAME, coords);
    }

    public static ComponentIdentifier createPypiCoordinates(String name, String version, String qualifier, String extension) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put("qualifier", qualifier);
        coords.put("extension", extension);
        return new ComponentIdentifier(FORMAT_PYPI, coords);
    }

    public static ComponentIdentifier createRpmCoordinates(String name, String version, String architecture) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put(RPM_ARCHITECTURE, architecture);
        return new ComponentIdentifier(FORMAT_RPM, coords);
    }

    public static ComponentIdentifier createRubyGemsCoordinates(String name, String version, String platform) {
        LinkedHashMap<String, String> coords = new LinkedHashMap<String, String>();
        coords.put("name", name);
        coords.put(VERSION, version);
        coords.put(RUBYGEMS_PLATFORM, platform);
        return new ComponentIdentifier(FORMAT_RUBYGEMS, coords);
    }

    public void ensureComplete() throws InvalidComponentIdentifierException {
        if (this.isMaven()) {
            this.validateRequiredCoordinates(MAVEN_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey(MAVEN_CLASSIFIER)) {
                this.coordinates.put(MAVEN_CLASSIFIER, "");
            }
        } else if (FORMAT_NPM.equals(this.format)) {
            this.validateRequiredCoordinates(NPM_REQUIRED_COORDINATES);
        } else if (FORMAT_NUGET.equals(this.format)) {
            this.validateRequiredCoordinates(NUGET_REQUIRED_COORDINATES);
        } else if (FORMAT_ANAME.equals(this.format)) {
            this.validateRequiredCoordinates(ANAME_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey("qualifier")) {
                this.coordinates.put("qualifier", "");
            }
        } else if (FORMAT_PYPI.equals(this.format)) {
            this.validateRequiredCoordinates(PYPI_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey("qualifier")) {
                this.coordinates.put("qualifier", "");
            }
        } else if (FORMAT_RPM.equals(this.format)) {
            this.validateRequiredCoordinates(RPM_REQUIRED_COORDINATES);
        } else if (FORMAT_RUBYGEMS.equals(this.format)) {
            this.validateRequiredCoordinates(RUBYGEMS_REQUIRED_COORDINATES);
            if (!this.coordinates.containsKey(RUBYGEMS_PLATFORM) || "".equals(this.coordinates.get(RUBYGEMS_PLATFORM))) {
                this.coordinates.put(RUBYGEMS_PLATFORM, RUBYGEMS_PLATFORM_DEFAULT);
            }
        }
    }

    private void validateRequiredCoordinates(Set<String> requiredKeys) throws InvalidComponentIdentifierException {
        if (!this.coordinates.keySet().containsAll(requiredKeys)) {
            TreeSet<String> keyCopy = new TreeSet<String>(requiredKeys);
            keyCopy.removeAll(this.coordinates.keySet());
            throw new InvalidComponentIdentifierException(MISSING_COORDINATES + keyCopy);
        }
    }

    public String toString() {
        return this.format + ": " + this.coordinates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ComponentIdentifier.hash(this.format);
        result = 31 * result + ComponentIdentifier.hash(this.coordinates);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ComponentIdentifier)) {
            return false;
        }
        ComponentIdentifier other = (ComponentIdentifier)obj;
        if (!ComponentIdentifier.eq(this.format, other.format)) {
            return false;
        }
        return this.coordinates.equals(other.getCoordinates());
    }

    private static <T> boolean eq(T obj1, T obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static int hash(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    @Override
    public int compareTo(ComponentIdentifier that) {
        int rel = this.format.compareTo(that.format);
        if (rel != 0) {
            return rel;
        }
        if (this.isMaven()) {
            return this.compareCoordinates(that, MAVEN_COORDINATE_NAMES);
        }
        if (FORMAT_NPM.equals(this.format)) {
            return this.compareCoordinates(that, NPM_COORDINATE_NAMES);
        }
        if (FORMAT_NUGET.equals(this.format)) {
            return this.compareCoordinates(that, NUGET_COORDINATE_NAMES);
        }
        if (FORMAT_ANAME.equals(this.format)) {
            return this.compareCoordinates(that, ANAME_COORDINATE_NAMES);
        }
        if (FORMAT_PYPI.equals(this.format)) {
            return this.compareCoordinates(that, PYPI_COORDINATE_NAMES);
        }
        if (FORMAT_RPM.equals(this.format)) {
            return this.compareCoordinates(that, RPM_COORDINATE_NAMES);
        }
        if (FORMAT_RUBYGEMS.equals(this.format)) {
            return this.compareCoordinates(that, RUBYGEMS_COORDINATE_NAMES);
        }
        return ComponentIdentifier.join(this.coordinates).compareTo(ComponentIdentifier.join(that.coordinates));
    }

    private int compareCoordinates(ComponentIdentifier that, LinkedHashSet<String> coordinateNames) {
        for (String coordinateName : coordinateNames) {
            int rel = ComponentIdentifier.compareNullableStrings(this.get(coordinateName), that.get(coordinateName));
            if (rel == 0) continue;
            return rel;
        }
        return 0;
    }

    private static String join(Map<String, String> coordinates) {
        if (coordinates == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (String value : coordinates.values()) {
            result.append(value);
        }
        return result.toString();
    }

    private static int compareNullableStrings(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        return s1.compareTo(s2);
    }

    public String getFormat() {
        return this.format;
    }

    public SortedMap<String, String> getCoordinates() {
        if (this.coordinates == null) {
            return UNMODIFIABLE_EMPTY_SORTED_MAP;
        }
        return Collections.unmodifiableSortedMap(this.coordinates);
    }

    public void validate() throws InvalidComponentIdentifierException {
        if (this.format == null || this.format.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_FORMAT_MESSAGE);
        }
        if (this.coordinates == null || this.coordinates.isEmpty()) {
            throw new InvalidComponentIdentifierException(MUST_HAVE_COORDINATE_MESSAGE);
        }
        if (this.format.equals(FORMAT_MAVEN)) {
            this.validateNoUnexpectedCoordinates(MAVEN_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NPM)) {
            this.validateNoUnexpectedCoordinates(NPM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_NUGET)) {
            this.validateNoUnexpectedCoordinates(NUGET_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_ANAME)) {
            this.validateNoUnexpectedCoordinates(ANAME_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_PYPI)) {
            this.validateNoUnexpectedCoordinates(PYPI_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_RPM)) {
            this.validateNoUnexpectedCoordinates(RPM_COORDINATE_NAMES);
        } else if (this.format.equals(FORMAT_RUBYGEMS)) {
            this.validateNoUnexpectedCoordinates(RUBYGEMS_COORDINATE_NAMES);
        }
    }

    private void validateNoUnexpectedCoordinates(Set<String> expectedKeys) {
        if (!expectedKeys.containsAll(this.coordinates.keySet())) {
            TreeSet<String> keyCopy = new TreeSet<String>(this.coordinates.keySet());
            keyCopy.removeAll(expectedKeys);
            throw new InvalidComponentIdentifierException(INCORRECT_COORDINATES + keyCopy);
        }
    }

    private void setCoordinates(Map<String, String> coordinates) {
        if (coordinates == null) {
            return;
        }
        this.coordinates = new TreeMap<String, String>();
        for (Map.Entry<String, String> coordinate : coordinates.entrySet()) {
            if (coordinate.getValue() == null) continue;
            this.coordinates.put(coordinate.getKey(), coordinate.getValue());
        }
    }

    @JsonIgnore
    public boolean isMaven() {
        return FORMAT_MAVEN.equals(this.format);
    }

    @JsonIgnore
    public boolean isAname() {
        return FORMAT_ANAME.equals(this.format);
    }

    static {
        FORMAT_TO_COORDINATES.put(FORMAT_MAVEN, Collections.unmodifiableSet(MAVEN_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_ANAME, Collections.unmodifiableSet(ANAME_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_NPM, Collections.unmodifiableSet(NPM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_NUGET, Collections.unmodifiableSet(NUGET_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_PYPI, Collections.unmodifiableSet(PYPI_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_RPM, Collections.unmodifiableSet(RPM_COORDINATE_NAMES));
        FORMAT_TO_COORDINATES.put(FORMAT_RUBYGEMS, Collections.unmodifiableSet(RUBYGEMS_COORDINATE_NAMES));
        FORMAT_TO_REQUIRED_COORDINATES = new HashMap<String, Set<String>>();
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_MAVEN, Collections.unmodifiableSet(MAVEN_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_ANAME, Collections.unmodifiableSet(ANAME_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_NPM, Collections.unmodifiableSet(NPM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_NUGET, Collections.unmodifiableSet(NUGET_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_PYPI, Collections.unmodifiableSet(PYPI_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_RPM, Collections.unmodifiableSet(RPM_REQUIRED_COORDINATES));
        FORMAT_TO_REQUIRED_COORDINATES.put(FORMAT_RUBYGEMS, Collections.unmodifiableSet(RUBYGEMS_REQUIRED_COORDINATES));
    }
}

