/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import com.sonatype.clm.dto.model.policy.ConditionFact;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ConstraintFact
implements Cloneable {
    private String constraintId;
    private String constraintName;
    private String operatorName;
    private List<ConditionFact> conditionFacts;

    public ConstraintFact() {
    }

    public ConstraintFact(String constraintId, String constraintName, String operatorName) {
        this.constraintId = constraintId;
        this.constraintName = constraintName;
        this.operatorName = operatorName;
    }

    public String getConstraintId() {
        return this.constraintId;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public List<ConditionFact> getConditionFacts() {
        return this.conditionFacts != null ? Collections.unmodifiableList(this.conditionFacts) : Collections.EMPTY_LIST;
    }

    public void addConditionFact(ConditionFact conditionFact) {
        if (this.conditionFacts == null) {
            this.conditionFacts = new ArrayList<ConditionFact>();
        }
        this.conditionFacts.add(conditionFact);
    }

    public ConstraintFact with(List<ConditionFact> newConditionFacts) {
        try {
            ConstraintFact clone = (ConstraintFact)this.clone();
            clone.conditionFacts = newConditionFacts;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException();
        }
    }

    public ConstraintFact with(ConditionFact ... newConditionFacts) {
        return this.with(Arrays.asList(newConditionFacts));
    }

    public String toString() {
        return "\n  Constraint(" + this.constraintName + ") " + this.conditionFacts + " ";
    }
}

