/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

public class PolicyEvaluationSummary {
    private String reportUrl;
    private int affectedComponentCount;
    private int criticalComponentCount;
    private int severeComponentCount;
    private int moderateComponentCount;

    public String resolveReportUrl(String serverUrl) {
        return PolicyEvaluationSummary.resolveUrl(serverUrl, this.getReportUrl());
    }

    private static String resolveUrl(String serverUrl, String resourceUrl) {
        if (serverUrl == null || serverUrl.isEmpty()) {
            throw new IllegalArgumentException("server base URL missing");
        }
        if (resourceUrl == null) {
            return resourceUrl;
        }
        StringBuilder url = new StringBuilder(256);
        url.append(serverUrl);
        if (!serverUrl.endsWith("/")) {
            url.append('/');
        }
        url.append(resourceUrl.startsWith("/") ? resourceUrl.substring(1) : resourceUrl);
        return url.toString();
    }

    public String getReportUrl() {
        return this.reportUrl;
    }

    public void setReportUrl(String reportUrl) {
        this.reportUrl = reportUrl;
    }

    public int getAffectedComponentCount() {
        return this.affectedComponentCount;
    }

    public void setAffectedComponentCount(int affectedComponentCount) {
        this.affectedComponentCount = affectedComponentCount;
    }

    public int getCriticalComponentCount() {
        return this.criticalComponentCount;
    }

    public void setCriticalComponentCount(int criticalComponentCount) {
        this.criticalComponentCount = criticalComponentCount;
    }

    public int getSevereComponentCount() {
        return this.severeComponentCount;
    }

    public void setSevereComponentCount(int severeComponentCount) {
        this.severeComponentCount = severeComponentCount;
    }

    public int getModerateComponentCount() {
        return this.moderateComponentCount;
    }

    public void setModerateComponentCount(int moderateComponentCount) {
        this.moderateComponentCount = moderateComponentCount;
    }
}

